% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.r
\name{tidy.harsm}
\alias{tidy.harsm}
\alias{tidy.hensm}
\title{Tidy}
\usage{
\method{tidy}{harsm}(x, ...)

\method{tidy}{hensm}(x, ...)
}
\arguments{
\item{x}{an object of type \code{harsm} or \code{hensm}}

\item{...}{arguments for generic consistency.}
}
\value{
A tidy \code{tibble::tibble()} with fields
\describe{
 \item{term}{The name of the estimated parameter. Betas typically come before gammas.}
 \item{estimate}{The estimated parameter.}
 \item{std.error}{The standard error of the estimate.}
 \item{statistic}{The z-statistic of the estimate.}
}
}
\description{
Tidy a harsm, hensm or linodds model.
}
\details{
Returns a table with information on the fit coefficients
and standard errors of an estimated Harville or Henery model.
}
\examples{

# softmax on the Best Picture data
data(best_picture)
df <- best_picture
df$place <- ifelse(df$winner,1,2)
df$weight <- ifelse(df$winner,1,0)

fmla <- place ~ nominated_for_BestDirector + nominated_for_BestActor + Drama
fit0 <- harsm(fmla,data=df,group=year,weights=weight)
print(tidy(fit0))

}
\seealso{
\code{\link[maxLik]{tidy.maxLik}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
