% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EOLL-G.R
\name{EOLLG}
\alias{EOLLG}
\alias{peollg}
\alias{deollg}
\alias{qeollg}
\alias{reollg}
\alias{heollg}
\title{Exponentiated Odd log-logistic family of distributions (EOLL-G)}
\usage{
peollg(x, alpha = 1, beta = 1, G = pnorm, ...)

deollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qeollg(q, alpha = 1, beta = 1, G = pnorm, ...)

reollg(n, alpha = 1, beta = 1, G = pnorm, ...)

heollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{peollg} gives the distribution function,
 \code{deollg} gives the density,
 \code{qeollg} gives the quantile function,
 \code{heollg} gives the hazard function and
 \code{reollg} generates random variables from the Exponentiated Odd log-logistic family of
 distributions (EOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers
of the beta extended distribution due to Alizadeh et al. (2020) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,G^{\alpha\beta-1}\bar{G}^{\alpha-1}}{[G^\alpha+\bar{G}^\alpha]^{\beta+1}}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
peollg(x)
peollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
deollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(deollg, -3, 3)
qeollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
reollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
heollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(heollg, -3, 3)
}
\references{
ALIZADEH, Morad; TAHMASEBI, Saeid; HAGHBIN, Hossein. The exponentiated odd log-logistic family of distributions: Properties and applications. Journal of Statistical Modelling: Theory and Applications, 2020, 1. Jg., Nr. 1, S. 29-52.
}
