% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZBOLL-G.R
\name{ZBOLLG}
\alias{ZBOLLG}
\alias{pzbollg}
\alias{dzbollg}
\alias{qzbollg}
\alias{rzbollg}
\alias{hzbollg}
\title{The Zografos-Balakrishnan  Odd log-logistic family of distributions (ZBOLL-G)}
\usage{
pzbollg(x, alpha = 1, beta = 1, G = pnorm, ...)

dzbollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qzbollg(q, alpha = 1, beta = 1, G = pnorm, ...)

rzbollg(n, alpha = 1, beta = 1, G = pnorm, ...)

hzbollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pzbollg} gives the distribution function,
 \code{dzbollg} gives the density,
 \code{qzbollg} gives the quantile function,
 \code{hzbollg} gives the hazard function and
 \code{rzbollg} generates random variables from the The Zografos-Balakrishnan  Odd log-logistic family of
 distributions (ZBOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Cordeiro et al. (2016) specified by the pdf
\deqn{f=\frac{\alpha\,g\,G^{\alpha-1}\bar{G}^{\alpha-1}}{\Gamma(\beta)[G^\alpha+\bar{G}^\alpha]^2}\,\{-\log[1-\frac{G^\alpha}{G^\alpha+\bar{G}^\alpha}]\}^{\beta-1}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf, \eqn{\Gamma(\beta)} the Gamma funcion,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pzbollg(x)
pzbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
dzbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dzbollg, -3, 3)
qzbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rzbollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
hzbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hzbollg, -3, 3)
}
\references{
Cordeiro, G. M., Alizadeh, M., Ortega, E. M., Serrano, L. H. V. (2016). The Zografos-Balakrishnan odd log-logistic family of distributions: Properties and Applications. Hacettepe Journal of Mathematics and Statistics, 45(6), 1781-1803. .
}
