% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_erode}
\alias{filter_erode}
\title{Filter: add an erosion effect to an element}
\usage{
filter_erode(radius = 1)
}
\arguments{
\item{radius}{The extent to which the source graphic will be eroded. If a
vector of two values are provided, the first value represents the x-radius
and the second one the y-radius. If one value is provided, then that value
is used for both x and y.}
}
\value{
An \code{svg} object.
}
\description{
The \code{filter_erode()} filter effectively thins out a source graphic by a given
\code{radius} value. The higher the \code{radius}, the greater the extent of thinning.
}
\examples{
if (interactive()) {

# Add a text element to an
# SVG drawing and erode it with
# the `filter_erode()` filter
SVG(width = 200, height = 100) \%>\%
  svg_filter(
    id = "erode",
    filters = list(
      filter_erode(radius = c(1, 0))
    )
  ) \%>\%
  svg_text(
    x = 10, y = 40,
    text = "Erosion",
    attrs = svg_attrs_pres(
      font_size = "3em",
      font_weight = "bolder",
      filter = "erode"
    )
  )
}

}
