% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/once.R
\name{once}
\alias{once}
\title{Execute Expensive Operations Only Once}
\usage{
once(expr, file_path = NULL, rerun = FALSE)
}
\arguments{
\item{expr}{The expensive expression to evaluate}

\item{file_path}{File path for saving the output object as an Rds file. Note that if no file name is provided it will not save!}

\item{rerun}{Rerun the expression anyway and save the result? Defaults to false.}
}
\value{
the results of expr
}
\description{
The \code{once()} function allows you to easily execute expensive compute operations only once, and save the resulting object to disk.
}
\examples{
save_file <- tempfile(fileext = ".Rds")
 # temporary file path - replace with your preferred saved file path
my_out <-
  runif(1e8) \%>\% # some expensive operation
  mean() \%>\%
  once(file_path = save_file)
  # only do it once, save output to this file.
}
