% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R, R/sample_predictive.R
\name{impute}
\alias{impute}
\alias{sample_predictive}
\title{Sample visits from predictive distribution}
\usage{
impute(
  model,
  data,
  nsim,
  n_per_group = NULL,
  sample = NULL,
  p = NULL,
  shape = NULL,
  scale = NULL,
  now = NULL,
  seed = NULL,
  nsim_parameters = 1000L,
  warmup_parameters = 250L,
  nuts_control = list(),
  as_mstate = FALSE,
  ...
)

sample_predictive(
  model,
  nsim,
  n_per_group,
  sample = NULL,
  p = NULL,
  shape = NULL,
  scale = NULL,
  seed = NULL,
  nsim_parameters = 1000L,
  warmup_parameters = 250,
  nuts_control = list(),
  as_mstate = FALSE,
  ...
)
}
\arguments{
\item{model}{an object of class \link{srpmodel} containing prior information}

\item{data}{a data frame with variables
\verb{subject_id<chr>} (subject identifier),
\verb{group_id<chr>} (group identifier),
\verb{t<dbl>} (time of visit, relative to first visit in study),
\verb{state<chr>} (state recorded at visit).
Allowed states are "stable", "response", "progression" (or death),
and "EOF" (end of follow-up).
The EOF state marks the end of an individual's follow-up before the absorbing
state "progression".}

\item{nsim}{integer, number of samples to draw}

\item{n_per_group}{integer vector with number of individuals per group.}

\item{sample}{a stanfit object with samples from the respective model.}

\item{p}{numeric, vector of optional fixed response probabilities to use for
sampling}

\item{shape}{numeric, matrix of optional fixed Weibull shape parameters to
use for sampling must be a matrix of dim c(n_groups, 3) where the second
dimension corresponds to the transitions between s->r, s->p, r->p}

\item{scale}{numeric, matrix of optional fixed Weibull scale parameters to
use for sampling must be a matrix of dim c(n_groups, 3) where the second
dimension corresponds to the transitions between s->r, s->p, r->p}

\item{now}{numeric, time since first visit in data if not last recorded
visit time}

\item{seed}{integer, fixed random seed; NULL for no fixed seed}

\item{nsim_parameters}{integer, number of parameter samples}

\item{warmup_parameters}{integer, number of warmup samples for the rstan sampler before retaining samples of the parameters.}

\item{nuts_control}{list, parameters for NUTS algorithm see \code{control}
argument in\code{\link[rstan:stan]{rstan::stan()}}}

\item{as_mstate}{logical, return data in mstate format?}

\item{...}{further arguments passed to method implementations}
}
\value{
a data frame with variables
\verb{subject_id<chr>} (subject identifier),
\verb{group_id<chr>} (group identifier),
\verb{t<dbl>} (time of visit, relative to first visit in study),
\verb{state<chr>} (state recorded at visit)
\verb{iter<int>} (re-sample indicator).
Allowed states are "stable", "response", "progression" (or death),
and "EOF" (end of follow-up).
The EOF state marks the end of an individual's follow-up before the absorbing
state "progression".
}
\description{
\code{impute()} samples visits for individuals in \code{data}
and potentially missing
individuals up to a maximum of \code{n_per_group} from the posterior
predictive distribution of the given model.

\code{sample_predictive()} draws samples from the predictive distribution of a
model given a parameter sample.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
tbl <- tibble::tibble(
  subject_id = c("A1", "A1"),
  group_id = c("A", "A"),
  t = c(0, 1.5),
  state = c("stable", "stable")
)
impute(mdl, tbl, 1L, seed = 38L)

sample_predictive(mdl, 1L, 20L, seed = 38L)

}
\seealso{
\code{\link[=sample_prior]{sample_prior()}} \code{\link[=sample_posterior]{sample_posterior()}}
}
