// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_srp_model_simple_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_srp_model_simple");
    reader.add_event(161, 159, "end", "model_srp_model_simple");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
beta_mix_trunc_lpdf(const T0__& p,
                        const T1__& mean,
                        const T2__& n,
                        const T3__& eta,
                        const T4__& lower,
                        const T5__& upper, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        local_scalar_t__ log_eps(DUMMY_VAR__);
        (void) log_eps;  // dummy to suppress unused var warning
        stan::math::initialize(log_eps, DUMMY_VAR__);
        stan::math::fill(log_eps, DUMMY_VAR__);
        stan::math::assign(log_eps,stan::math::log(1e-6));
        current_statement_begin__ = 7;
        local_scalar_t__ a(DUMMY_VAR__);
        (void) a;  // dummy to suppress unused var warning
        stan::math::initialize(a, DUMMY_VAR__);
        stan::math::fill(a, DUMMY_VAR__);
        stan::math::assign(a,(mean * n));
        current_statement_begin__ = 8;
        local_scalar_t__ b(DUMMY_VAR__);
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b, DUMMY_VAR__);
        stan::math::assign(b,((1 - mean) * n));
        current_statement_begin__ = 9;
        local_scalar_t__ log1m_eta(DUMMY_VAR__);
        (void) log1m_eta;  // dummy to suppress unused var warning
        stan::math::initialize(log1m_eta, DUMMY_VAR__);
        stan::math::fill(log1m_eta, DUMMY_VAR__);
        stan::math::assign(log1m_eta,log1m(eta));
        current_statement_begin__ = 10;
        local_scalar_t__ log_eta(DUMMY_VAR__);
        (void) log_eta;  // dummy to suppress unused var warning
        stan::math::initialize(log_eta, DUMMY_VAR__);
        stan::math::fill(log_eta, DUMMY_VAR__);
        stan::math::assign(log_eta,stan::math::log(eta));
        current_statement_begin__ = 12;
        local_scalar_t__ norm(DUMMY_VAR__);
        (void) norm;  // dummy to suppress unused var warning
        stan::math::initialize(norm, DUMMY_VAR__);
        stan::math::fill(norm, DUMMY_VAR__);
        stan::math::assign(norm,log_sum_exp((log1m_eta + log_diff_exp(beta_cdf_log(upper, a, b), beta_cdf_log(lower, a, b))), (log_eta + stan::math::log((upper - lower)))));
        current_statement_begin__ = 14;
        local_scalar_t__ lpdf(DUMMY_VAR__);
        (void) lpdf;  // dummy to suppress unused var warning
        stan::math::initialize(lpdf, DUMMY_VAR__);
        stan::math::fill(lpdf, DUMMY_VAR__);
        stan::math::assign(lpdf,(log_sum_exp((log1m_eta + beta_log(p, a, b)), log_eta) - norm));
        current_statement_begin__ = 15;
        if (as_bool((primitive_value(logical_lt(p, lower)) || primitive_value(logical_gt(p, upper))))) {
            current_statement_begin__ = 16;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << p;
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 18;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_sum_exp(lpdf, log_eps));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
beta_mix_trunc_lpdf(const T0__& p,
                        const T1__& mean,
                        const T2__& n,
                        const T3__& eta,
                        const T4__& lower,
                        const T5__& upper, std::ostream* pstream__) {
    return beta_mix_trunc_lpdf<false>(p,mean,n,eta,lower,upper, pstream__);
}
struct beta_mix_trunc_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const T0__& p,
                        const T1__& mean,
                        const T2__& n,
                        const T3__& eta,
                        const T4__& lower,
                        const T5__& upper, std::ostream* pstream__) const {
        return beta_mix_trunc_lpdf(p, mean, n, eta, lower, upper, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_srp_model_simple
  : public stan::model::model_base_crtp<model_srp_model_simple> {
private:
        int M_groups;
        int N;
        int N_subjects;
        double maximal_time;
        std::vector<int> subject_id;
        std::vector<int> group_id;
        std::vector<int> from;
        std::vector<int> to;
        std::vector<double> t_min;
        std::vector<double> t_max;
        std::vector<double> p_mean;
        std::vector<double> p_n;
        std::vector<double> p_eta;
        std::vector<double> p_min;
        std::vector<double> p_max;
        std::vector<std::vector<double> > shape_mu;
        std::vector<std::vector<double> > shape_sigma;
        std::vector<std::vector<double> > median_t_mu;
        std::vector<std::vector<double> > median_t_sigma;
public:
    model_srp_model_simple(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_srp_model_simple(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_srp_model_simple_namespace::model_srp_model_simple";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "M_groups", "int", context__.to_vec());
            M_groups = int(0);
            vals_i__ = context__.vals_i("M_groups");
            pos__ = 0;
            M_groups = vals_i__[pos__++];
            check_greater_or_equal(function__, "M_groups", M_groups, 1);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "N_subjects", "int", context__.to_vec());
            N_subjects = int(0);
            vals_i__ = context__.vals_i("N_subjects");
            pos__ = 0;
            N_subjects = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_subjects", N_subjects, 0);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "maximal_time", "double", context__.to_vec());
            maximal_time = double(0);
            vals_r__ = context__.vals_r("maximal_time");
            pos__ = 0;
            maximal_time = vals_r__[pos__++];
            check_greater_or_equal(function__, "maximal_time", maximal_time, 0);
            current_statement_begin__ = 32;
            validate_non_negative_index("subject_id", "N", N);
            context__.validate_dims("data initialization", "subject_id", "int", context__.to_vec(N));
            subject_id = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("subject_id");
            pos__ = 0;
            size_t subject_id_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < subject_id_k_0_max__; ++k_0__) {
                subject_id[k_0__] = vals_i__[pos__++];
            }
            size_t subject_id_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < subject_id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "subject_id[i_0__]", subject_id[i_0__], 1);
            }
            current_statement_begin__ = 33;
            validate_non_negative_index("group_id", "N", N);
            context__.validate_dims("data initialization", "group_id", "int", context__.to_vec(N));
            group_id = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("group_id");
            pos__ = 0;
            size_t group_id_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < group_id_k_0_max__; ++k_0__) {
                group_id[k_0__] = vals_i__[pos__++];
            }
            size_t group_id_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < group_id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "group_id[i_0__]", group_id[i_0__], 1);
            }
            current_statement_begin__ = 34;
            validate_non_negative_index("from", "N", N);
            context__.validate_dims("data initialization", "from", "int", context__.to_vec(N));
            from = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("from");
            pos__ = 0;
            size_t from_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < from_k_0_max__; ++k_0__) {
                from[k_0__] = vals_i__[pos__++];
            }
            size_t from_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < from_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "from[i_0__]", from[i_0__], 1);
                check_less_or_equal(function__, "from[i_0__]", from[i_0__], 2);
            }
            current_statement_begin__ = 35;
            validate_non_negative_index("to", "N", N);
            context__.validate_dims("data initialization", "to", "int", context__.to_vec(N));
            to = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("to");
            pos__ = 0;
            size_t to_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < to_k_0_max__; ++k_0__) {
                to[k_0__] = vals_i__[pos__++];
            }
            size_t to_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < to_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "to[i_0__]", to[i_0__], 2);
                check_less_or_equal(function__, "to[i_0__]", to[i_0__], 4);
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("t_min", "N", N);
            context__.validate_dims("data initialization", "t_min", "double", context__.to_vec(N));
            t_min = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("t_min");
            pos__ = 0;
            size_t t_min_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < t_min_k_0_max__; ++k_0__) {
                t_min[k_0__] = vals_r__[pos__++];
            }
            size_t t_min_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < t_min_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "t_min[i_0__]", t_min[i_0__], 0);
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("t_max", "N", N);
            context__.validate_dims("data initialization", "t_max", "double", context__.to_vec(N));
            t_max = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("t_max");
            pos__ = 0;
            size_t t_max_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < t_max_k_0_max__; ++k_0__) {
                t_max[k_0__] = vals_r__[pos__++];
            }
            size_t t_max_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < t_max_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "t_max[i_0__]", t_max[i_0__], 0);
            }
            current_statement_begin__ = 41;
            validate_non_negative_index("p_mean", "M_groups", M_groups);
            context__.validate_dims("data initialization", "p_mean", "double", context__.to_vec(M_groups));
            p_mean = std::vector<double>(M_groups, double(0));
            vals_r__ = context__.vals_r("p_mean");
            pos__ = 0;
            size_t p_mean_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_mean_k_0_max__; ++k_0__) {
                p_mean[k_0__] = vals_r__[pos__++];
            }
            size_t p_mean_i_0_max__ = M_groups;
            for (size_t i_0__ = 0; i_0__ < p_mean_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p_mean[i_0__]", p_mean[i_0__], stan::math::machine_precision());
                check_less_or_equal(function__, "p_mean[i_0__]", p_mean[i_0__], (1 - stan::math::machine_precision()));
            }
            current_statement_begin__ = 42;
            validate_non_negative_index("p_n", "M_groups", M_groups);
            context__.validate_dims("data initialization", "p_n", "double", context__.to_vec(M_groups));
            p_n = std::vector<double>(M_groups, double(0));
            vals_r__ = context__.vals_r("p_n");
            pos__ = 0;
            size_t p_n_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_n_k_0_max__; ++k_0__) {
                p_n[k_0__] = vals_r__[pos__++];
            }
            size_t p_n_i_0_max__ = M_groups;
            for (size_t i_0__ = 0; i_0__ < p_n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p_n[i_0__]", p_n[i_0__], stan::math::machine_precision());
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("p_eta", "M_groups", M_groups);
            context__.validate_dims("data initialization", "p_eta", "double", context__.to_vec(M_groups));
            p_eta = std::vector<double>(M_groups, double(0));
            vals_r__ = context__.vals_r("p_eta");
            pos__ = 0;
            size_t p_eta_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_eta_k_0_max__; ++k_0__) {
                p_eta[k_0__] = vals_r__[pos__++];
            }
            size_t p_eta_i_0_max__ = M_groups;
            for (size_t i_0__ = 0; i_0__ < p_eta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p_eta[i_0__]", p_eta[i_0__], 0.0);
                check_less_or_equal(function__, "p_eta[i_0__]", p_eta[i_0__], 1.0);
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("p_min", "M_groups", M_groups);
            context__.validate_dims("data initialization", "p_min", "double", context__.to_vec(M_groups));
            p_min = std::vector<double>(M_groups, double(0));
            vals_r__ = context__.vals_r("p_min");
            pos__ = 0;
            size_t p_min_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_min_k_0_max__; ++k_0__) {
                p_min[k_0__] = vals_r__[pos__++];
            }
            size_t p_min_i_0_max__ = M_groups;
            for (size_t i_0__ = 0; i_0__ < p_min_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p_min[i_0__]", p_min[i_0__], 0.0);
                check_less_or_equal(function__, "p_min[i_0__]", p_min[i_0__], 1.0);
            }
            current_statement_begin__ = 45;
            validate_non_negative_index("p_max", "M_groups", M_groups);
            context__.validate_dims("data initialization", "p_max", "double", context__.to_vec(M_groups));
            p_max = std::vector<double>(M_groups, double(0));
            vals_r__ = context__.vals_r("p_max");
            pos__ = 0;
            size_t p_max_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_max_k_0_max__; ++k_0__) {
                p_max[k_0__] = vals_r__[pos__++];
            }
            size_t p_max_i_0_max__ = M_groups;
            for (size_t i_0__ = 0; i_0__ < p_max_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "p_max[i_0__]", p_max[i_0__], 0.0);
                check_less_or_equal(function__, "p_max[i_0__]", p_max[i_0__], 1.0);
            }
            current_statement_begin__ = 47;
            validate_non_negative_index("shape_mu", "M_groups", M_groups);
            validate_non_negative_index("shape_mu", "3", 3);
            context__.validate_dims("data initialization", "shape_mu", "double", context__.to_vec(M_groups,3));
            shape_mu = std::vector<std::vector<double> >(M_groups, std::vector<double>(3, double(0)));
            vals_r__ = context__.vals_r("shape_mu");
            pos__ = 0;
            size_t shape_mu_k_0_max__ = M_groups;
            size_t shape_mu_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < shape_mu_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < shape_mu_k_0_max__; ++k_0__) {
                    shape_mu[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("shape_sigma", "M_groups", M_groups);
            validate_non_negative_index("shape_sigma", "3", 3);
            context__.validate_dims("data initialization", "shape_sigma", "double", context__.to_vec(M_groups,3));
            shape_sigma = std::vector<std::vector<double> >(M_groups, std::vector<double>(3, double(0)));
            vals_r__ = context__.vals_r("shape_sigma");
            pos__ = 0;
            size_t shape_sigma_k_0_max__ = M_groups;
            size_t shape_sigma_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < shape_sigma_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < shape_sigma_k_0_max__; ++k_0__) {
                    shape_sigma[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t shape_sigma_i_0_max__ = M_groups;
            size_t shape_sigma_i_1_max__ = 3;
            for (size_t i_0__ = 0; i_0__ < shape_sigma_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < shape_sigma_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "shape_sigma[i_0__][i_1__]", shape_sigma[i_0__][i_1__], stan::math::machine_precision());
                }
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("median_t_mu", "M_groups", M_groups);
            validate_non_negative_index("median_t_mu", "3", 3);
            context__.validate_dims("data initialization", "median_t_mu", "double", context__.to_vec(M_groups,3));
            median_t_mu = std::vector<std::vector<double> >(M_groups, std::vector<double>(3, double(0)));
            vals_r__ = context__.vals_r("median_t_mu");
            pos__ = 0;
            size_t median_t_mu_k_0_max__ = M_groups;
            size_t median_t_mu_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < median_t_mu_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < median_t_mu_k_0_max__; ++k_0__) {
                    median_t_mu[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("median_t_sigma", "M_groups", M_groups);
            validate_non_negative_index("median_t_sigma", "3", 3);
            context__.validate_dims("data initialization", "median_t_sigma", "double", context__.to_vec(M_groups,3));
            median_t_sigma = std::vector<std::vector<double> >(M_groups, std::vector<double>(3, double(0)));
            vals_r__ = context__.vals_r("median_t_sigma");
            pos__ = 0;
            size_t median_t_sigma_k_0_max__ = M_groups;
            size_t median_t_sigma_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < median_t_sigma_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < median_t_sigma_k_0_max__; ++k_0__) {
                    median_t_sigma[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t median_t_sigma_i_0_max__ = M_groups;
            size_t median_t_sigma_i_1_max__ = 3;
            for (size_t i_0__ = 0; i_0__ < median_t_sigma_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < median_t_sigma_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "median_t_sigma[i_0__][i_1__]", median_t_sigma[i_0__][i_1__], stan::math::machine_precision());
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 59;
            validate_non_negative_index("shape", "M_groups", M_groups);
            validate_non_negative_index("shape", "3", 3);
            num_params_r__ += ((1 * M_groups) * 3);
            current_statement_begin__ = 60;
            validate_non_negative_index("p_raw", "M_groups", M_groups);
            num_params_r__ += (1 * M_groups);
            current_statement_begin__ = 61;
            validate_non_negative_index("median_t", "M_groups", M_groups);
            validate_non_negative_index("median_t", "3", 3);
            num_params_r__ += ((1 * M_groups) * 3);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_srp_model_simple() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 59;
        if (!(context__.contains_r("shape")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable shape missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("shape");
        pos__ = 0U;
        validate_non_negative_index("shape", "M_groups", M_groups);
        validate_non_negative_index("shape", "3", 3);
        context__.validate_dims("parameter initialization", "shape", "double", context__.to_vec(M_groups,3));
        std::vector<std::vector<double> > shape(M_groups, std::vector<double>(3, double(0)));
        size_t shape_k_0_max__ = M_groups;
        size_t shape_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < shape_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < shape_k_0_max__; ++k_0__) {
                shape[k_0__][k_1__] = vals_r__[pos__++];
            }
        }
        size_t shape_i_0_max__ = M_groups;
        size_t shape_i_1_max__ = 3;
        for (size_t i_0__ = 0; i_0__ < shape_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < shape_i_1_max__; ++i_1__) {
                try {
                    writer__.scalar_lb_unconstrain(0.5, shape[i_0__][i_1__]);
                } catch (const std::exception& e) {
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable shape: ") + e.what()), current_statement_begin__, prog_reader__());
                }
            }
        }
        current_statement_begin__ = 60;
        if (!(context__.contains_r("p_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "M_groups", M_groups);
        context__.validate_dims("parameter initialization", "p_raw", "double", context__.to_vec(M_groups));
        std::vector<double> p_raw(M_groups, double(0));
        size_t p_raw_k_0_max__ = M_groups;
        for (size_t k_0__ = 0; k_0__ < p_raw_k_0_max__; ++k_0__) {
            p_raw[k_0__] = vals_r__[pos__++];
        }
        size_t p_raw_i_0_max__ = M_groups;
        for (size_t i_0__ = 0; i_0__ < p_raw_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0, 1, p_raw[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 61;
        if (!(context__.contains_r("median_t")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable median_t missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("median_t");
        pos__ = 0U;
        validate_non_negative_index("median_t", "M_groups", M_groups);
        validate_non_negative_index("median_t", "3", 3);
        context__.validate_dims("parameter initialization", "median_t", "double", context__.to_vec(M_groups,3));
        std::vector<std::vector<double> > median_t(M_groups, std::vector<double>(3, double(0)));
        size_t median_t_k_0_max__ = M_groups;
        size_t median_t_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < median_t_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < median_t_k_0_max__; ++k_0__) {
                median_t[k_0__][k_1__] = vals_r__[pos__++];
            }
        }
        size_t median_t_i_0_max__ = M_groups;
        size_t median_t_i_1_max__ = 3;
        for (size_t i_0__ = 0; i_0__ < median_t_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < median_t_i_1_max__; ++i_1__) {
                try {
                    writer__.scalar_lb_unconstrain(stan::math::sqrt(stan::math::machine_precision()), median_t[i_0__][i_1__]);
                } catch (const std::exception& e) {
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable median_t: ") + e.what()), current_statement_begin__, prog_reader__());
                }
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 59;
            std::vector<std::vector<local_scalar_t__> > shape;
            size_t shape_d_0_max__ = M_groups;
            size_t shape_d_1_max__ = 3;
            shape.resize(shape_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < shape_d_0_max__; ++d_0__) {
                shape[d_0__].reserve(shape_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < shape_d_1_max__; ++d_1__) {
                    if (jacobian__)
                        shape[d_0__].push_back(in__.scalar_lb_constrain(0.5, lp__));
                    else
                        shape[d_0__].push_back(in__.scalar_lb_constrain(0.5));
                }
            }
            current_statement_begin__ = 60;
            std::vector<local_scalar_t__> p_raw;
            size_t p_raw_d_0_max__ = M_groups;
            p_raw.reserve(p_raw_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < p_raw_d_0_max__; ++d_0__) {
                if (jacobian__)
                    p_raw.push_back(in__.scalar_lub_constrain(0, 1, lp__));
                else
                    p_raw.push_back(in__.scalar_lub_constrain(0, 1));
            }
            current_statement_begin__ = 61;
            std::vector<std::vector<local_scalar_t__> > median_t;
            size_t median_t_d_0_max__ = M_groups;
            size_t median_t_d_1_max__ = 3;
            median_t.resize(median_t_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < median_t_d_0_max__; ++d_0__) {
                median_t[d_0__].reserve(median_t_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < median_t_d_1_max__; ++d_1__) {
                    if (jacobian__)
                        median_t[d_0__].push_back(in__.scalar_lb_constrain(stan::math::sqrt(stan::math::machine_precision()), lp__));
                    else
                        median_t[d_0__].push_back(in__.scalar_lb_constrain(stan::math::sqrt(stan::math::machine_precision())));
                }
            }
            // transformed parameters
            current_statement_begin__ = 69;
            validate_non_negative_index("p", "M_groups", M_groups);
            std::vector<local_scalar_t__> p(M_groups, local_scalar_t__(0));
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p, DUMMY_VAR__);
            current_statement_begin__ = 70;
            validate_non_negative_index("scale", "M_groups", M_groups);
            validate_non_negative_index("scale", "3", 3);
            std::vector<std::vector<local_scalar_t__> > scale(M_groups, std::vector<local_scalar_t__>(3, local_scalar_t__(0)));
            stan::math::initialize(scale, DUMMY_VAR__);
            stan::math::fill(scale, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 72;
            for (int g = 1; g <= M_groups; ++g) {
                current_statement_begin__ = 74;
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()), 
                            (get_base1(p_min, g, "p_min", 1) + ((get_base1(p_max, g, "p_max", 1) - get_base1(p_min, g, "p_min", 1)) * get_base1(p_raw, g, "p_raw", 1))), 
                            "assigning variable p");
                current_statement_begin__ = 75;
                for (int j = 1; j <= 3; ++j) {
                    current_statement_begin__ = 77;
                    stan::model::assign(scale, 
                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (get_base1(get_base1(median_t, g, "median_t", 1), j, "median_t", 2) / pow(stan::math::log(2), (1 / get_base1(get_base1(shape, g, "shape", 1), j, "shape", 2)))), 
                                "assigning variable scale");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 69;
            size_t p_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(p[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable p: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 70;
            size_t scale_k_0_max__ = M_groups;
            size_t scale_k_1_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < scale_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < scale_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(scale[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: scale" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable scale: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 88;
            local_scalar_t__ eps(DUMMY_VAR__);
            (void) eps;  // dummy to suppress unused var warning
            stan::math::initialize(eps, DUMMY_VAR__);
            stan::math::fill(eps, DUMMY_VAR__);
            stan::math::assign(eps,1e-6);
            current_statement_begin__ = 89;
            int g(0);
            (void) g;  // dummy to suppress unused var warning
            stan::math::fill(g, std::numeric_limits<int>::min());
            current_statement_begin__ = 90;
            int s(0);
            (void) s;  // dummy to suppress unused var warning
            stan::math::fill(s, std::numeric_limits<int>::min());
            current_statement_begin__ = 93;
            validate_non_negative_index("t_jump_from_stable", "N_subjects", N_subjects);
            std::vector<local_scalar_t__  > t_jump_from_stable(N_subjects, local_scalar_t__(DUMMY_VAR__));
            stan::math::initialize(t_jump_from_stable, DUMMY_VAR__);
            stan::math::fill(t_jump_from_stable, DUMMY_VAR__);
            current_statement_begin__ = 96;
            for (int gg = 1; gg <= M_groups; ++gg) {
                current_statement_begin__ = 98;
                lp_accum__.add(beta_mix_trunc_lpdf(get_base1(p, gg, "p", 1), get_base1(p_mean, gg, "p_mean", 1), get_base1(p_n, gg, "p_n", 1), get_base1(p_eta, gg, "p_eta", 1), get_base1(p_min, gg, "p_min", 1), get_base1(p_max, gg, "p_max", 1), pstream__));
                current_statement_begin__ = 101;
                for (int j = 1; j <= 3; ++j) {
                    current_statement_begin__ = 102;
                    lp_accum__.add(lognormal_log<propto__>(get_base1(get_base1(shape, gg, "shape", 1), j, "shape", 2), get_base1(get_base1(shape_mu, gg, "shape_mu", 1), j, "shape_mu", 2), get_base1(get_base1(shape_sigma, gg, "shape_sigma", 1), j, "shape_sigma", 2)));
                    current_statement_begin__ = 104;
                    lp_accum__.add(lognormal_log<propto__>(get_base1(get_base1(median_t, gg, "median_t", 1), j, "median_t", 2), get_base1(get_base1(median_t_mu, gg, "median_t_mu", 1), j, "median_t_mu", 2), get_base1(get_base1(median_t_sigma, gg, "median_t_sigma", 1), j, "median_t_sigma", 2)));
                }
            }
            current_statement_begin__ = 109;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 110;
                stan::math::assign(s, get_base1(subject_id, i, "subject_id", 1));
                current_statement_begin__ = 111;
                stan::math::assign(g, get_base1(group_id, i, "group_id", 1));
                current_statement_begin__ = 112;
                if (as_bool(logical_eq(get_base1(from, i, "from", 1), 1))) {
                    current_statement_begin__ = 116;
                    stan::model::assign(t_jump_from_stable, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                ((get_base1(t_min, i, "t_min", 1) + get_base1(t_max, i, "t_max", 1)) / 2), 
                                "assigning variable t_jump_from_stable");
                    current_statement_begin__ = 117;
                    if (as_bool(logical_eq(get_base1(to, i, "to", 1), 2))) {
                        current_statement_begin__ = 118;
                        lp_accum__.add(stan::math::log(((get_base1(p, g, "p", 1) * (weibull_cdf((get_base1(t_max, i, "t_max", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 1, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 1, "scale", 2)) - weibull_cdf((get_base1(t_min, i, "t_min", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 1, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 1, "scale", 2)))) + eps)));
                    }
                    current_statement_begin__ = 123;
                    if (as_bool(logical_eq(get_base1(to, i, "to", 1), 3))) {
                        current_statement_begin__ = 124;
                        lp_accum__.add(stan::math::log((((1 - get_base1(p, g, "p", 1)) * (weibull_cdf((get_base1(t_max, i, "t_max", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 2, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 2, "scale", 2)) - weibull_cdf((get_base1(t_min, i, "t_min", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 2, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 2, "scale", 2)))) + eps)));
                    }
                    current_statement_begin__ = 129;
                    if (as_bool(logical_eq(get_base1(to, i, "to", 1), 4))) {
                        current_statement_begin__ = 132;
                        lp_accum__.add(stan::math::log((((get_base1(p, g, "p", 1) * (1 - weibull_cdf((get_base1(t_min, i, "t_min", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 1, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 1, "scale", 2)))) + ((1 - get_base1(p, g, "p", 1)) * (1 - weibull_cdf((get_base1(t_min, i, "t_min", 1) + eps), get_base1(get_base1(shape, g, "shape", 1), 2, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 2, "scale", 2))))) + eps)));
                    }
                }
                current_statement_begin__ = 138;
                if (as_bool(logical_eq(get_base1(from, i, "from", 1), 2))) {
                    current_statement_begin__ = 146;
                    if (as_bool(logical_eq(get_base1(to, i, "to", 1), 3))) {
                        current_statement_begin__ = 147;
                        lp_accum__.add(stan::math::log(((weibull_cdf(((get_base1(t_max, i, "t_max", 1) - get_base1(t_jump_from_stable, s, "t_jump_from_stable", 1)) + eps), get_base1(get_base1(shape, g, "shape", 1), 3, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 3, "scale", 2)) - weibull_cdf(((get_base1(t_min, i, "t_min", 1) - get_base1(t_jump_from_stable, s, "t_jump_from_stable", 1)) + eps), get_base1(get_base1(shape, g, "shape", 1), 3, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 3, "scale", 2))) + eps)));
                    }
                    current_statement_begin__ = 152;
                    if (as_bool(logical_eq(get_base1(to, i, "to", 1), 4))) {
                        current_statement_begin__ = 153;
                        lp_accum__.add(stan::math::log(((1 - weibull_cdf(((get_base1(t_min, i, "t_min", 1) - get_base1(t_jump_from_stable, s, "t_jump_from_stable", 1)) + eps), get_base1(get_base1(shape, g, "shape", 1), 3, "shape", 2), get_base1(get_base1(scale, g, "scale", 1), 3, "scale", 2))) + eps)));
                    }
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("shape");
        names__.push_back("p_raw");
        names__.push_back("median_t");
        names__.push_back("p");
        names__.push_back("scale");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(M_groups);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_groups);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_groups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_groups);
        dims__.push_back(3);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_srp_model_simple_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<std::vector<double> > shape;
        size_t shape_d_0_max__ = M_groups;
        size_t shape_d_1_max__ = 3;
        shape.resize(shape_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < shape_d_0_max__; ++d_0__) {
            shape[d_0__].reserve(shape_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < shape_d_1_max__; ++d_1__) {
                shape[d_0__].push_back(in__.scalar_lb_constrain(0.5));
            }
        }
        size_t shape_k_0_max__ = M_groups;
        size_t shape_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < shape_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < shape_k_0_max__; ++k_0__) {
                vars__.push_back(shape[k_0__][k_1__]);
            }
        }
        std::vector<double> p_raw;
        size_t p_raw_d_0_max__ = M_groups;
        p_raw.reserve(p_raw_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < p_raw_d_0_max__; ++d_0__) {
            p_raw.push_back(in__.scalar_lub_constrain(0, 1));
        }
        size_t p_raw_k_0_max__ = M_groups;
        for (size_t k_0__ = 0; k_0__ < p_raw_k_0_max__; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
        }
        std::vector<std::vector<double> > median_t;
        size_t median_t_d_0_max__ = M_groups;
        size_t median_t_d_1_max__ = 3;
        median_t.resize(median_t_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < median_t_d_0_max__; ++d_0__) {
            median_t[d_0__].reserve(median_t_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < median_t_d_1_max__; ++d_1__) {
                median_t[d_0__].push_back(in__.scalar_lb_constrain(stan::math::sqrt(stan::math::machine_precision())));
            }
        }
        size_t median_t_k_0_max__ = M_groups;
        size_t median_t_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < median_t_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < median_t_k_0_max__; ++k_0__) {
                vars__.push_back(median_t[k_0__][k_1__]);
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 69;
            validate_non_negative_index("p", "M_groups", M_groups);
            std::vector<double> p(M_groups, double(0));
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p, DUMMY_VAR__);
            current_statement_begin__ = 70;
            validate_non_negative_index("scale", "M_groups", M_groups);
            validate_non_negative_index("scale", "3", 3);
            std::vector<std::vector<double> > scale(M_groups, std::vector<double>(3, double(0)));
            stan::math::initialize(scale, DUMMY_VAR__);
            stan::math::fill(scale, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 72;
            for (int g = 1; g <= M_groups; ++g) {
                current_statement_begin__ = 74;
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()), 
                            (get_base1(p_min, g, "p_min", 1) + ((get_base1(p_max, g, "p_max", 1) - get_base1(p_min, g, "p_min", 1)) * get_base1(p_raw, g, "p_raw", 1))), 
                            "assigning variable p");
                current_statement_begin__ = 75;
                for (int j = 1; j <= 3; ++j) {
                    current_statement_begin__ = 77;
                    stan::model::assign(scale, 
                                stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (get_base1(get_base1(median_t, g, "median_t", 1), j, "median_t", 2) / pow(stan::math::log(2), (1 / get_base1(get_base1(shape, g, "shape", 1), j, "shape", 2)))), 
                                "assigning variable scale");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t p_k_0_max__ = M_groups;
                for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                    vars__.push_back(p[k_0__]);
                }
                size_t scale_k_0_max__ = M_groups;
                size_t scale_k_1_max__ = 3;
                for (size_t k_1__ = 0; k_1__ < scale_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < scale_k_0_max__; ++k_0__) {
                        vars__.push_back(scale[k_0__][k_1__]);
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_srp_model_simple";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t shape_k_0_max__ = M_groups;
        size_t shape_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < shape_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < shape_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "shape" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t p_raw_k_0_max__ = M_groups;
        for (size_t k_0__ = 0; k_0__ < p_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t median_t_k_0_max__ = M_groups;
        size_t median_t_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < median_t_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < median_t_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "median_t" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t p_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t scale_k_0_max__ = M_groups;
            size_t scale_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < scale_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < scale_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "scale" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t shape_k_0_max__ = M_groups;
        size_t shape_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < shape_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < shape_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "shape" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t p_raw_k_0_max__ = M_groups;
        for (size_t k_0__ = 0; k_0__ < p_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t median_t_k_0_max__ = M_groups;
        size_t median_t_k_1_max__ = 3;
        for (size_t k_1__ = 0; k_1__ < median_t_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < median_t_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "median_t" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t p_k_0_max__ = M_groups;
            for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t scale_k_0_max__ = M_groups;
            size_t scale_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < scale_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < scale_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "scale" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_srp_model_simple_namespace::model_srp_model_simple stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
