% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pop_query.R
\name{get_pop_query}
\alias{get_pop_query}
\title{Get Population Data}
\usage{
get_pop_query(token, data_type, planning_area, year, gender = NULL)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{data_type}{Type of data to be retrieved, should correspond to one of the API endpoints. E.g. to get economic status data, \code{data_type = "getEconomicStatus"}. The API endpoints can be found on the documentation page.}

\item{planning_area}{Town for which the data should be retrieved.}

\item{year}{Year for which the data should be retrieved.}

\item{gender}{Optional, valid values include \code{male} and \code{female}. If specified, only records for that gender will be returned. This parameter is only valid for the \code{"getEconomicStatus"}, \code{"getEthnicGroup"}, \code{"getMaritalStatus"} and \code{"getPopulationAgeGroup"} endpoints. If specified for other endpoints, the parameter will be dropped. If gender is not specified for valid endpoints, records for total, male and female will be returned.}
}
\value{
A tibble with 1 row and values for all the corresponding variables returned by the API endpoint.
If an error occurs, the function returns NULL and a warning message. This differs from the error handling of other functions in this package to prevent collective failure for \code{get_pop_queries}.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/populationquery}{Population Query API}. It only allows for querying of one data type (i.e. one of the API endpoints) for a particular town and year.
}
\examples{
# output with no NA
\dontrun{get_pop_query(token, "getReligion", "Yishun", "2010")}
\dontrun{get_pop_query(token, "getModeOfTransportSchool", "Bishan", "2015", "female")}

# if gender parameter is not specified, results for both genders and total will be returned
\dontrun{get_pop_query(token, "getMaritalStatus", "Bedok", "2010")}
\dontrun{get_pop_query(token, "getEthnicGroup", "Bedok", "2010")}
\dontrun{get_pop_query(token, "getPopulationAgeGroup", "Bedok", "2010")}

# output due to error
\dontrun{get_pop_query(token, "getSpokenAtHome", "Bedok", "2043")}

}
