% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{onto_plot}
\alias{onto_plot}
\title{Get \code{ontology_plot} object}
\usage{
onto_plot(
  ontology,
  term_sets = NULL,
  frequencies = NULL,
  terms = remove_uninformative_terms(ontology, term_sets),
  edge_attributes = list(color = "#000000", lty = "solid"),
  fillcolor = "powderblue",
  label = simple_labels,
  color = "transparent",
  width = 0.75,
  fontsize = 30,
  style = "filled",
  fixedsize = "true",
  shape = "circle",
  ...
)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}

\item{frequencies}{Numeric vector of term frequencies named by term IDs}

\item{terms}{Character vector of ontological terms}

\item{edge_attributes}{List of properties to set for arrows (note, these properties will be used for all arrow).}

\item{fillcolor}{Character vector of colours to fill nodes corresponding to \code{terms} with. Alternatively a function to set the colours of the nodes in the graph based on \code{term_sets}.}

\item{label}{Character vector of labels (or function to set them).}

\item{color}{Character vector of colours for borders of nodes representing \code{terms} (or function to set them).}

\item{width}{Numeric vector of widths for nodes (of function to set them).}

\item{fontsize}{Numeric vector of font sizes for the text to be placed in the nodes (or function to set them).}

\item{style}{Display style for nodes, defaults to \code{"filled"}.}

\item{fixedsize}{Character indicating whether nodes should be fixed size, \code{"true"}, or adjusted to fit around the contained text, \code{"false"}.}

\item{shape}{Character vector of shape names for nodes (or function to set them). Defaults to \code{"circle"}.}

\item{...}{Other node attributes for dot format.}
}
\value{
\code{ontology_plot} object.
}
\description{
A convenience wrapper for the \code{\link{get_ontology_plot}} function, enabling functions to be passed to generate graphical parameters for \code{terms} automatically.
}
\examples{
library(ontologyIndex)
data(hpo)
hpo_phenotypes <- c(
	A=c("HP:0001382","HP:0004272","HP:0007917","HP:0004912","HP:0001596"),
	B=c("HP:0001382","HP:0004272","HP:0002165","HP:0004800","HP:0004912"),
	C=c("HP:0004800","HP:0001382","HP:0004912","HP:0007917","HP:0008743"),
	D=c("HP:0001257","HP:0001382","HP:0007917","HP:0012623","HP:0002165"),
	E=c("HP:0007917","HP:0004800","HP:0004272","HP:0001596","HP:0002165")
)

onto_plot(
	ontology=hpo,
	term_sets=hpo_phenotypes
)
}
\seealso{
\code{\link{get_ontology_plot}}, \code{\link{write_dot}}
}
