% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{paramo.list}
\alias{paramo.list}
\title{Stack multiple discrete stochastic character map lists}
\usage{
paramo.list(cc, tree.list, ntrees = 1)
}
\arguments{
\item{cc}{character. Characters IDs to stack.}

\item{tree.list}{multiSimmap or multiPhylo object. Named list with stochastic character maps.}

\item{ntrees}{integer. Number of trees to stack.}
}
\value{
A list of stacked stochastic character maps.
}
\description{
Performs the final stacking of maps for a set of stochastic character maps stored in a list.
}
\examples{
data("hym_stm")
# Select the first five characters.
tree_list <- hym_stm[1:5]
tree_list <- lapply(tree_list, function(x) discr_Simmap_all(x, res = 100))
tree_list_amalg <- paramo.list(names(tree_list), tree_list, ntrees = 50)
tree_list_amalg <- do.call(c, tree_list_amalg)
# Plot one amalgamated stochastic map.
phytools::plotSimmap(tree_list_amalg[[1]], get_rough_state_cols(tree_list_amalg[[1]]),  
lwd = 3, pts = FALSE,ftype = "off")

}
\author{
Sergei Tarasov
}
