#' Male and female births in London
#'
#' Arbuthnot's data describes male and female christenings (births) for
#' London from 1629-1710.
#'
#' John Arbuthnot (1710) used these time series data to carry out the first
#' known significance test. During every one of the 82 years, there were more
#' male christenings than female christenings. As Arbuthnot wondered,
#' we might also wonder if this could be due to chance, or whether it meant
#' the birth ratio was not actually 1:1.
#'
#' @format A tbl_df with with 82 rows and 3 variables:
#' \describe{
#'   \item{year}{year, ranging from 1629 to 1710}
#'   \item{boys}{number of male christenings (births)}
#'   \item{girls}{number of female christenings (births)}
#' }
#' @source These data are excerpted from the `Arbuthnot` dataset in the
#' [HistData](https://CRAN.R-project.org/package=HistData) package.
#' @examples
#'
#' library(ggplot2)
#' library(tidyr)
#'
#' # All births
#' ggplot(arbuthnot, aes(x = year, y = boys + girls, group = 1)) +
#'   geom_line()
#'
#' # Boys and girls
#' arbuthnot |>
#'   pivot_longer(cols = -year, names_to = "sex", values_to = "n") |>
#'   ggplot(aes(x = year, y = n, color = sex, group = sex)) +
#'   geom_line()
"arbuthnot"
