% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-cars93.R
\docType{data}
\name{cars93}
\alias{cars93}
\title{cars93}
\format{
A data frame with 54 observations on the following 6 variables.
\describe{
\item{type}{The vehicle type with levels \code{large}, \code{midsize},
and \code{small}.}
\item{price}{Vehicle price (USD).}
\item{mpg_city}{Vehicle mileage in city (miles per gallon).}
\item{drive_train}{Vehicle drive train with levels \code{4WD}, \code{front},
and \code{rear}.}
\item{passengers}{The vehicle passenger capacity.}
\item{weight}{Vehicle weight (lbs).}
}
}
\source{
Lock, R. H. (1993) 1993 New Car Data. \emph{Journal of Statistics
Education} 1(1).
}
\usage{
cars93
}
\description{
A data frame with 54 rows and 6 columns. This data is a subset of the
\code{Cars93} dataset from the \code{MASS} package.
}
\details{
These cars represent a random sample for 1993 models that were in both
\emph{Consumer Reports} and \emph{PACE Buying Guide}. Only vehicles of type
\code{small}, \code{midsize}, and \code{large} were include.

Further description can be found in Lock (1993). Use the URL
\url{http://jse.amstat.org/v1n1/datasets.lock.html}.
}
\examples{

library(ggplot2)

# Vehicle price by type
ggplot(cars93, aes(x = price)) +
  geom_histogram(binwidth = 5) +
  facet_wrap(~type)

# Vehicle price vs. weight
ggplot(cars93, aes(x = weight, y = price)) +
  geom_point()

# Milleage vs. weight
ggplot(cars93, aes(x = weight, y = mpg_city)) +
  geom_point() +
  geom_smooth()
}
\keyword{datasets}
