% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-UserFiles.R
\name{get_user_files}
\alias{get_user_files}
\alias{upload_user_files}
\alias{create_user_files_folder}
\alias{delete_user_files}
\alias{delete_user_files_all}
\title{Manage OpenM++ User Files}
\usage{
get_user_files(ext = "*", path = "")

upload_user_files(path)

create_user_files_folder(path)

delete_user_files(path)

delete_user_files_all()
}
\arguments{
\item{ext}{Comma-separated string of file extensions. Default is \code{"*"} which
returns all files.}

\item{path}{Optional file path. Default is \code{""} (empty) and returns the
entire tree of user files.}
}
\value{
A \code{list} from JSON response object or nothing (invisibly).
}
\description{
Functions for getting, setting, and deleting user file. More information
about these API endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#download-and-upload-user-files}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_user_files()
}


}
