% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ModelWorksetMetadata.R
\name{get_workset}
\alias{get_workset}
\alias{get_worksets_list}
\alias{get_worksets}
\alias{get_scenarios}
\alias{get_workset_status}
\alias{get_workset_status_default}
\title{Model Workset Metadata}
\usage{
get_workset(model, set)

get_worksets_list(model)

get_worksets(model)

get_scenarios(model)

get_workset_status(model, set)

get_workset_status_default(model)
}
\arguments{
\item{model}{Model digest or model name.}

\item{set}{Name of workset (input set of model parameters).}
}
\value{
A \code{list}, \code{tibble}, or nothing (invisibly).
}
\description{
Functions for creating, copying, merging, retrieving, and deleting
worksets. More information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#get-model-workset-metadata-set-of-input-parameters}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_worksets("RiskPaths")
get_scenarios("RiskPaths")
get_workset("RiskPaths", "Default")
}


}
