% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassModelRunSet.R
\name{load_model_runs}
\alias{load_model_runs}
\alias{load_runs}
\alias{OpenMppModelRunSet}
\title{OpenM++ ModelRunSet Class}
\usage{
load_model_runs(model, runs)

load_runs(model, runs)
}
\arguments{
\item{model}{Model name or digest.}

\item{runs}{Character vector of model run names, digests, or stamps.}
}
\value{
An \code{OpenMppModelRunSet} instance.
}
\description{
OpenM++ ModelRunSet Class
}
\details{
\code{load_runs()} is an alias for \code{load_model_runs()}.
}
\examples{
\dontrun{
use_OpenMpp_local()
load_model_runs("RiskPaths", rep("53300e8b56eabdf5e5fb112059e8c137", 2))
load_runs("RiskPaths", rep("53300e8b56eabdf5e5fb112059e8c137", 2))
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ModelDigest}}{Model digest.}

\item{\code{ModelName}}{Model name.}

\item{\code{ModelVersion}}{Model version.}

\item{\code{OpenMppType}}{OpenM++ object type (used for \code{print()}).}

\item{\code{Tables}}{Model run output tables}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{RunNames}}{Run names.}

\item{\code{RunDigests}}{Run digests.}

\item{\code{RunStamps}}{Run stamps.}

\item{\code{RunStatuses}}{Run statuses.}

\item{\code{RunMetadatas}}{Run metadatas.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenMppModelRunSet-new}{\code{OpenMppModelRunSet$new()}}
\item \href{#method-OpenMppModelRunSet-print}{\code{OpenMppModelRunSet$print()}}
\item \href{#method-OpenMppModelRunSet-get_table}{\code{OpenMppModelRunSet$get_table()}}
\item \href{#method-OpenMppModelRunSet-get_table_calc}{\code{OpenMppModelRunSet$get_table_calc()}}
\item \href{#method-OpenMppModelRunSet-write_table}{\code{OpenMppModelRunSet$write_table()}}
\item \href{#method-OpenMppModelRunSet-write_tables}{\code{OpenMppModelRunSet$write_tables()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-new}{}}}
\subsection{Method \code{new()}}{
Create a new OpenMppModelRunSet object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$new(model, runs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model digest or name.}

\item{\code{runs}}{Run digests, run stamps, or run names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{OpenMppModelRunSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{OpenMppModelRunSet} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not currently used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-get_table"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-get_table}{}}}
\subsection{Method \code{get_table()}}{
Retrieve a table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$get_table(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-get_table_calc"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-get_table_calc}{}}}
\subsection{Method \code{get_table_calc()}}{
Retrieve a table calculation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$get_table_calc(name, calc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}

\item{\code{calc}}{Name of calculation. One of \code{"avg"}, \code{"sum"}, \code{"count"},
\code{"max"}, \code{"min"}, \code{"var"}, \code{"sd"}, \code{"se"}, or \code{"cv"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-write_table"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-write_table}{}}}
\subsection{Method \code{write_table()}}{
Write an output table to disk (CSV).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$write_table(name, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}

\item{\code{file}}{File path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRunSet-write_tables"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRunSet-write_tables}{}}}
\subsection{Method \code{write_tables()}}{
Write all output tables to disk (CSV).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRunSet$write_tables(dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{Directory path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
}
