% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsx2-package.R
\docType{package}
\name{openxlsx2-package}
\alias{openxlsx2}
\alias{openxlsx2-package}
\title{xlsx reading, writing and editing.}
\description{
This R package is a modern reinterpretation of the widely used popular
\code{openxlsx} package. Similar to its predecessor, it simplifies the creation of xlsx
files by providing a clean interface for writing, designing and editing worksheets.
Based on a powerful XML library and focusing on modern programming flows in pipes
or chains, \code{openxlsx2} allows to break many new ground.
}
\details{
The \code{openxlsx2} package provides comprehensive functionality for interacting
with Office Open XML spreadsheet files. Users can read data using \code{\link[=read_xlsx]{read_xlsx()}}
and write data to spreadsheets via \code{\link[=write_xlsx]{write_xlsx()}}, with options to specify
sheet names and cell ranges for targeted operations. Beyond basic read/write
capabilities, \code{openxlsx2} facilitates extensive workbook (\code{\link[=wb_workbook]{wb_workbook()}})
manipulations, including:
\itemize{
\item Loading a workbook into R with \code{\link[=wb_load]{wb_load()}} and saving it with \code{\link[=wb_save]{wb_save()}}
\item Adding/removing and modifying worksheets and data with \code{\link[=wb_add_worksheet]{wb_add_worksheet()}},
\code{\link[=wb_remove_worksheet]{wb_remove_worksheet()}}, and \code{\link[=wb_add_data]{wb_add_data()}}.
\item Enhancing spreadsheets with comments (\code{\link[=wb_add_comment]{wb_add_comment()}}),
images (\code{\link[=wb_add_image]{wb_add_image()}}), plots (\code{\link[=wb_add_plot]{wb_add_plot()}}), charts (\code{\link[=wb_add_mschart]{wb_add_mschart()}}),
and pivot tables (\code{\link[=wb_add_pivot_table]{wb_add_pivot_table()}}).
Customizing cell styles using fonts (\code{\link[=wb_add_font]{wb_add_font()}}),
number formats (\code{\link[=wb_add_numfmt]{wb_add_numfmt()}}), backgrounds (\code{\link[=wb_add_fill]{wb_add_fill()}}),
and alignments (\code{\link[=wb_add_cell_style]{wb_add_cell_style()}}). Inserting custom text strings with
\code{\link[=fmt_txt]{fmt_txt()}} and creating comprehensive table styles with \code{\link[=create_tablestyle]{create_tablestyle()}}.
}
\subsection{Interaction}{

Interaction with \code{openxlsx2} objects can occur through two primary methods:

\emph{Wrapper Function Method}: Utilizes the \code{wb} family of functions that support
piping to streamline operations.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{wb <- wb_workbook(creator = "My name here") |>
  wb_add_worksheet(sheet = "Expenditure", grid_lines = FALSE) |>
  wb_add_data(x = USPersonalExpenditure, row_names = TRUE)
}\if{html}{\out{</div>}}

\emph{Chaining Method}: Directly modifies the object through a series of chained
function calls.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{wb <- wb_workbook(creator = "My name here")$
  add_worksheet(sheet = "Expenditure", grid_lines = FALSE)$
  add_data(x = USPersonalExpenditure, row_names = TRUE)
}\if{html}{\out{</div>}}

While wrapper functions require explicit assignment of their output to reflect
changes, chained functions inherently modify the input object. Both approaches
are equally supported, offering flexibility to suit user preferences. The
documentation mainly highlights the use of wrapper functions. To find information,
users should look up the wb function name e.g. \code{?wb_add_data_table} rather than
searching for \code{?wbWorkbook}.

Function arguments follow the snake_case convention, but for backward compatibility,
camelCase is also supported at the moment. The API aims to maintain consistency
in its arguments, with a special focus on \code{sheet} (\code{\link[=wb_get_sheet_names]{wb_get_sheet_names()}}) and
\code{dims} (\link{wb_dims}), which are of particular importance to users.
}

\subsection{Locale}{

By default, \code{openxlsx2} uses the American English word for color (written with
'o' instead of the British English 'ou'). However, both spellings are supported.
So where the documentation uses a 'color', the function should also accept a 'colour'.
However, this is not indicated by the autocompletion.
}

\subsection{Numeric Precision}{

R typically uses IEEE 754 double-precision floating-point
numbers. When \code{openxlsx2} writes these R numeric values to a spreadsheet,
it stores them using double precision (and shortens if possible) within
the file structure. However, spreadsheet software operates with, displays,
and performs calculations using only about 15 significant decimal digits.
If spreadsheet software encounters a number with higher precision (like one
written by \code{openxlsx2}), it will typically round that number to 15
significant digits for its internal use and display. Conversely, when
reading numeric data from an xlsx/xlsm file, \code{openxlsx2} reads the stored
double-precision value. However, potential discrepancies can still arise.
If the number was originally created or calculated within spreadsheet
software and exceeded 15 digits, it may have already rounded before saving.
Additionally, subtle rounding differences can sometimes occur during the
XML-to-numeric conversion when reading the file into R. Expect minor
variations, especially in the least significant digits, and avoid direct
equality (\code{==}) comparisons; check for differences within a small
tolerance instead.
}

\subsection{Supported files}{

Supported input files include \code{xlsx}, \code{xlsm}, and \code{xlsb}. The \code{xlsx} and
\code{xlsm} formats are fully supported. The key difference between these two
formats is that \code{xlsm} files may contain a binary blob that stores VBA
code, while \code{xlsx} files do not.

Support for the \code{xlsb} format is more limited. A custom parser is used to
convert the binary format into a pseudo-XML structure that can be loaded
into a \code{\link{wbWorkbook}}. This allows \code{xlsb} files to be handled similarly to
other workbook formats. However, the parser does not fully implement the
entire \code{xlsb} specification. It provides functionality to read worksheets
into data frames and to save the content as an \code{xlsx} or \code{xlsm} file for
comparison of values and formulas. Some components, such as pivot tables
and conditional formatting, are not currently parsed. Writing \code{xlsb} files
is not supported, and big endian support is very limited. At present,
there are no plans to extend support for \code{xlsb} files further, due to the
complexity of the format. It is recommended to use spreadsheet software to
convert files to or from the \code{xlsb} format when necessary.

The XML-based formats (\code{xlsx} and \code{xlsm}) are fully supported. Loading,
modifying, and saving these files with minimal unintended changes is a
core project goal. Nevertheless, the XML format can be fragile. Modifying
cells that interact with formulas, named objects such as tables or
regions, slicers, or pivot tables can lead to unexpected behavior. It is
therefore strongly advised to keep backups of important files and to
regularly verify the output using appropriate spreadsheet software.
}

\subsection{Authors and contributions}{

For a full list of all authors that have made this package possible and for whom we are grateful, please see:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{system.file("AUTHORS", package = "openxlsx2")
}\if{html}{\out{</div>}}

If you feel like you should be included on this list, please let us know.
If you have something to contribute, you are welcome.
If something is not working as expected, open issues or if you have solved an issue, open a pull request.
Please be respectful and be aware that we are volunteers doing this for fun in our unpaid free time.
We will work on problems when we have time or need.
}

\subsection{License}{

This package is licensed under the MIT license and
is based on \href{https://github.com/ycphs/openxlsx}{\code{openxlsx}} (by Alexander Walker and Philipp Schauberger; COPYRIGHT 2014-2022)
and \href{https://github.com/zeux/pugixml}{\code{pugixml}} (by Arseny Kapoulkine; COPYRIGHT 2006-2025). Both released under the MIT license.
}
}
\examples{
# read xlsx or xlsm files
path <- system.file("extdata/openxlsx2_example.xlsx", package = "openxlsx2")
read_xlsx(path)

# or import workbooks
wb <- wb_load(path)

# read a data frame
wb_to_df(wb)

# and save
temp <- temp_xlsx()
if (interactive()) wb_save(wb, temp)

## or create one yourself
wb <- wb_workbook()
# add a worksheet
wb$add_worksheet("sheet")
# add some data
wb$add_data("sheet", cars)
# open it in your default spreadsheet software
if (interactive()) wb$open()
}
\seealso{
\itemize{
\item \code{browseVignettes("openxlsx2")}
\item \url{https://janmarvin.github.io/openxlsx2/}
\item \url{https://janmarvin.github.io/ox2-book/}
for examples
}
}
\author{
\strong{Maintainer}: Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Authors:
\itemize{
  \item Jordan Mark Barbone \email{jmbarbone@gmail.com} (\href{https://orcid.org/0000-0001-9788-3628}{ORCID})
}

Other contributors:
\itemize{
  \item Olivier Roy [contributor]
  \item  openxlsx authors (openxlsx package) [copyright holder]
  \item Arseny Kapoulkine (Author of included pugixml code) [contributor, copyright holder]
}

}
\keyword{internal}
