% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optR.R
\name{optR}
\alias{optR}
\title{Optimization & predictive modelling Toolsets}
\usage{
optR(x, ...)
}
\arguments{
\item{x}{: Input matrix}

\item{...}{: S3 method}
}
\value{
optR   : Return optR class
}
\description{
optR function for solving linear systems using numerical approaches. 
Current toolbox supports Gauss Elimination, LU decomposition, Conjugate Gradiant Decent and Gauss-Sideal methods for solving the system of form AX=b
For optimization using numerical methods cgm method performed faster in comparision with gaussseidel.
For decomposition LU is utilized for multiple responses to enhance the speed of computation.
}
\examples{
# Solving equation Ax=b
A<-matrix(c(6,-4,1, -4,6,-4,1,-4,6), nrow=3,ncol=3, byrow = TRUE)
b<-matrix(c(-14,36, 6), nrow=3,ncol=1,byrow=TRUE)
Z<-optR(A, b, method="gauss") # Solve Linear model using Gauss Elimination

# Solve Linear model using LU decomposition (Supports Multi-response)
Z<-optR(A, b, method="LU") 

# Solve the matrix using Gauss Elimination (1, -1, 2)
A<-matrix(c(2,-2,6, -2,4,3,-1,8,4), nrow=3,ncol=3, byrow = TRUE)
b<-matrix(c(16,0, -1), nrow=3,ncol=1,byrow=TRUE)
Z<-optR(A, b, method="gauss") # Solve Linear model using Gauss Elimination

require(utils)
set.seed(129)
n <- 10 ; p <- 4
X <- matrix(rnorm(n * p), n, p) # no intercept!
y <- rnorm(n)
Z<-optR(X, y, method="cgm")
}
\author{
PKS Prakash
}

