% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{plot.TrialDesignOptimalConditionalError}
\alias{plot.TrialDesignOptimalConditionalError}
\title{Plot the optimal conditional error function}
\usage{
\method{plot}{TrialDesignOptimalConditionalError}(x, range = c(0, 1), type = 1, plotNonMonotoneFunction = FALSE, ...)
}
\arguments{
\item{x}{Design object of class \code{TrialDesignOptimalConditionalError}.}

\item{range}{Numeric vector with two entries specifying the range of the x-axis of the plot.}

\item{type}{Type of plot to be created. Options are: \itemize{
\item \code{type = 1}: Plot the values of the optimal conditional error function against the first-stage p-value.
\item \code{type = 2}: Plot the second-stage information resulting from the optimal conditional error function against the first-stage p-value.
\item \code{type = 3}: Plot the likelihood ratio of the given specification of the optimal conditional error function against the first-stage p-value.
\item \code{type = 4}: Plot the function Q of the given specification of the optimal conditional error function against the first-stage p-value.
}}

\item{plotNonMonotoneFunction}{Logical. Should the non-monotone version of the plot be drawn? Not applicable for plot type 3. Default: \code{FALSE}.}

\item{...}{Additional arguments required for generic compatibility}
}
\value{
No return value, plots the design.
}
\description{
The returned plot is a \code{ggplot2} object and can be supplemented with additional layers using \code{ggplot2} commands.
}
