% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{densCurves}
\alias{densCurves}
\title{Density curves plot}
\usage{
densCurves(x0, x1, type, ylab = "Density", xlab = "Marker values",
  main = "Density curves", col0 = "blue", col1 = "green", lty0 = 1,
  lty1 = 1, pos.legend = "topright", ...)
}
\arguments{
\item{x0}{a numeric vector containing the marker values of patients in the reference arm (treatment selection marker), or non-diseased patients (diagnostic marker).}

\item{x1}{a numeric vector containing the marker values of patients in the innovative arm (treatment selection marker), or diseased patients (diagnostic marker).}

\item{type}{a character argument that specifies the type of the marker ("treatment selection" for treatment selection marker or "diagnostic" for diagnostic marker).}

\item{ylab}{label of the Y-axis.}

\item{xlab}{label of the X-axis.}

\item{main}{title of the graph.}

\item{col0}{color of the density curve in the reference arm (treatment selection marker), or for non-diseased patients (diagnostic marker).}

\item{col1}{color of the density curve in the innovative arm (treatment selection marker), or for diseased patients (diagnostic marker).}

\item{lty0}{type of the line for the density curve in the reference arm (treatment selection marker), or for non-diseased patients (diagnostic marker).}

\item{lty1}{type of the line for the density curve in the innovative arm (treatment selection marker), or for diseased patients (diagnostic marker).}

\item{pos.legend}{the x and y co-ordinates to be used to position the legend. They can be specified by keyword or in any way which is accepted by xy.coords.}

\item{...}{other arguments to be passed to the plot function.}
}
\value{
None
}
\description{
This function plots the density curves of the marker values in each treatment arm (treatment selection marker), or for diseased and non-diseased patients (diagnostic marker).
}
\details{
When assessing treatment selection markers and estimating their optimal threshold, it is necessary that the randomization constraint be respected. If the density curves of the marker are different when comparing the two treatment arms, then it is likely that the \code{trtSelThresh} function will provide a threshold that do not correspond to the true optimal threshold. 
When assessing diagnostic markers, it is necessary to define the decision rule (classically high values of the marker are associated with a worst outcome). This decision rule may be checked with the density curves of the marker for diseased and non-diseased patients.
}
\examples{
### Plotting density curves for a treatment selection marker
# Data generation
x0E <- rnorm(100, 2, 1)
x0Eb <- rnorm(200, 4, 1)
x1E <- rnorm(100, 4, 1)
x1Eb <- rnorm(200, 2, 1)
densCurves(x0 = c(x0E, x0Eb), x1 = c(x1E, x1Eb), type = "treatment selection")

### Plotting density curves for a diagnostic marker
# Data generation
xE <- rnorm(30, 3, 1)
xEb <- rnorm(90, 1, 1)
densCurves(x0 = xEb, x1 = xE, type = "diagnostic")
}
