% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassDiagRelUtility.R
\docType{methods}
\name{plot.diagRelUtility}
\alias{plot.diagRelUtility}
\alias{plot,diagRelUtility-method}
\title{Plot the decision curves of a diagnostic marker}
\usage{
\S4method{plot}{diagRelUtility}(x, y, main = "Decision curves",
  lty = 1, lwd = 1, xlim = range(x@r), ylim = c(min(x@U,
  x@UNoTreat, x@UTreatAll), max(x@U, x@UNoTreat, x@UTreatAll)),
  ylab = "Expected benefit", xlab = "r", col.U = "black",
  col.UNoTreat = "blue", col.UTreatAll = "green", ...)
}
\arguments{
\item{x}{a \code{diagRelUtility} object.}

\item{y}{unused parameter.}

\item{main}{an overall title for the plot.}

\item{lty}{the line type. Line types can either be specified as an integer (0=blank, 1=solid (default), 2=dashed, 3=dotted, 4=dotdash, 5=longdash, 6=twodash) or as one of the character strings "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash", where "blank" uses 'invisible lines' (i.e., does not draw them).}

\item{lwd}{the line width, a \emph{positive} number, defaulting to 1. The interpretation is device-specific, and some devices do not implement line widths less than one. (See the help on the device for details of the interpretation).}

\item{xlim}{the x limits of the plot.}

\item{ylim}{the x limits of the plot.}

\item{ylab}{a label for the y axis.}

\item{xlab}{a label for the x axis}

\item{col.U}{color of the utility curve for the marker-based strategy.}

\item{col.UNoTreat}{color of the utility curve for the "No Treat" strategy.}

\item{col.UTreatAll}{color of the utility curve for the "Treat All" strategy.}

\item{...}{other graphical parameters.}
}
\value{
None
}
\description{
Plot the decision curves of a diagnostic marker
}
