% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplePosteriorDist.R
\docType{methods}
\name{samplePosteriorDist}
\alias{samplePosteriorDist}
\alias{samplePosteriorDist,fitNormalDist-method}
\alias{samplePosteriorDist.fitNormalDist}
\alias{samplePosteriorDist,fitLogNormalDist-method}
\alias{samplePosteriorDist.fitLogNormalDist}
\alias{samplePosteriorDist,fitGammaDist-method}
\alias{samplePosteriorDist.fitGammaDist}
\alias{samplePosteriorDist,fitStudentDist-method}
\alias{samplePosteriorDist.fitStudentDist}
\alias{samplePosteriorDist,fitLogisticDist-method}
\alias{samplePosteriorDist.fitLogisticDist}
\title{Sample in the posterior distribution of the parameters of a given theoretical distribution.}
\usage{
samplePosteriorDist(object, K, ...)

\S4method{samplePosteriorDist}{fitNormalDist}(object, K, n)

\S4method{samplePosteriorDist}{fitLogNormalDist}(object, K, n)

\S4method{samplePosteriorDist}{fitGammaDist}(object, K, do.pb, seed)

\S4method{samplePosteriorDist}{fitStudentDist}(object, K, do.pb, seed)

\S4method{samplePosteriorDist}{fitLogisticDist}(object, K, do.pb, seed)
}
\arguments{
\item{object}{A distribution object.}

\item{K}{A numerical value indicating the length of the sample.}

\item{...}{other parameters passed to methods.}

\item{n}{number of MCMC chains.}

\item{do.pb}{Indicates whther progressing bar or not}

\item{seed}{seed for the random number generator. Integer.}
}
\value{
Returns an object of class list.
}
\description{
The \code{samplePosteriorDist} function samples the parameters of a given theoretical distribution using explicit posterior distribution (if it exists), or a Markov Chain Monte Carlo (MCMC) algorithm when the posterior distribution is unknown. See details to know on what kind of S4 objects this function could be applied.
}
\details{
This method can be applied to the S4 distribution objects that are supported in the \code{optimalThreshold} package: \code{fitNormalDist}, \code{fitLogNormalDist}, \code{fitGammaDist}, \code{fitStudentDist}, and \code{fitLogisticDist}. These methods are applied internally, and you have no need to use it outside of the main function \code{optThresEst}. See below to have details on the expression of the \code{samplePosteriorDist} function according to the type of distribution.
\itemize{
\item Normal distribution: a noninformative prior is used for the parameters of the normal distribution (\code{mu}=\eqn{\mu}, and \code{sd}=\eqn{\sigma}). The \eqn{\sigma^2} parameter is sampled from an inverse Chi-squared distribution, and the \eqn{\mu} parameter is sampled from a normal distribution with known variance. So, sampling in the posterior distribution of \eqn{\mu} and \eqn{\sigma} does not involve an MCMC algorithm (see References for more details and justification).
\item Log-normal distribution: a noninformative prior is used for the parameters of the log-normal distribution (\code{mu}=\eqn{\mu}, and \code{sd}=\eqn{\sigma}). The \eqn{\sigma^2} parameter is sampled from an inverse Chi-squared distribution, and the \eqn{\mu} parameter is sampled from a normal distribution with known variance. So, sampling in the posterior distribution of \eqn{\mu} and \eqn{\sigma} does not involve an MCMC algorithm (see References for more details and justification).
\item Gamma distribution: a noninformative prior is used for the parameters of the gamma distribution (\code{shape}=\eqn{\alpha}, and \code{scale}=\eqn{\beta}). The parameters are sampled using an adaptive rejection sampling (ARS) algorithm. The \eqn{\beta} parameter is sampled at the first iteration from an inverse gamma distribution using the initial value of the \eqn{\alpha} parameter provided by the user. Then the ARS algorithm is performed to sample \eqn{\alpha} from its posterior distribution (see References for more details and justification).
\item Scaled t distribution: a vague prior is used for the parameters of the scaled t distribution as a default. However, the user can write its own JAGS model to use different priors (see the \code{fit} function for more details). Sampling from the posterior distribution of the parameters of a scaled t distribution requires JAGS to be installed.
\item Logistic distribution: a vague prior is used for the parameters of the logistic distribution as a default. However, the user can write its own JAGS model to use different priors (see the \code{fit} function for more details). Sampling from the posterior distribution of the parameters of a logistic distribution requires JAGS to be installed.
}
}
\section{References}{

Gelman, A, et al. 2014. \emph{Bayesian Data Analysis}. 3rd edition, CRC Press, Boca Raton, section 2.8.
Sook, Y, and Oh, M. Bayesian estimation of the two-parameter Gamma distribution. \emph{Communications in Statistics - Simulation and Computation}. 2006; 35: 285-293.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}}
}
