% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{optionvega}
\alias{optionvega}
\title{Option Vega}
\usage{
optionvega(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use r.cont}

\item{d}{Annual continuously-compounded dividend yield, use r.cont}
}
\value{
Returns the option vega
}
\description{
Calculates the vega of a European- style call and put option
}
\details{
Vega measures the change in the option's value given a 1% change in the implied volatility.
}
\examples{
optionvega(100, 100, 0.20, (45/365), 0.02, 0.02)
}
