% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCullagh_palindromic_symmetry.R
\name{McCullagh_newton_raphson_update}
\alias{McCullagh_newton_raphson_update}
\title{Newton-Raphson update.}
\usage{
McCullagh_newton_raphson_update(
  n,
  gradient,
  hessian,
  psi,
  delta,
  alpha,
  c = 1,
  max_iter = 50,
  verbose = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{gradient}{gradient vector}

\item{hessian}{hessian matrix}

\item{psi}{matrix of symmetry parameters}

\item{delta}{scalar or vector of asymmetry parameters}

\item{alpha}{vector of asymmetry parameters}

\item{c}{scaling factor to ensure pi sums to 1.0. Default is 1.0}

\item{max_iter}{maximum number of iterations.  Default is 50.}

\item{verbose}{should cycle-by-cycle into be printed out. Default is FALSE,
do not print.}
}
\value{
list containing new parameters
   psi: matrix of symmetry parameters
   delta; scalar or vector of asymmetry parameters
   alpha: vector of asymmetry parameters
   c: scaling coefficient to ensure pi sums to 1.0
}
\description{
Using gradient and hessian, it finds the update direction. Then it tries increassingly
smaller step sizes until the step*update yields a valid pi matrix.
}
