% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_linear.R
\name{log_linear_remove_column}
\alias{log_linear_remove_column}
\title{Removes a column from an existing design matrix.}
\usage{
log_linear_remove_column(x, position = ncol(x))
}
\arguments{
\item{x}{the original design matrix}

\item{position}{column index within the new matrix for the new column.
Defaults to last position}
}
\value{
the new design matrix
}
\description{
Takes the design matrix provided and removes the column in the position specified
}
\examples{
x <- log_linear_main_effect_design(vision_data)
linear <- log_linear_create_linear_by_linear(vision_data)
x_prime <- log_linear_append_column(x, linear)
x_again <- log_linear_remove_column(x_prime, ncol(x_prime))
}
