% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distsummin.R
\name{distsummin}
\alias{distsummin}
\alias{distsummin,loca.p-method}
\title{Returns the solution of the minimization problem}
\usage{
distsummin(
  o,
  x = 0,
  y = 0,
  lp = numeric(0),
  max.iter = 1e+05,
  eps = 0.001,
  verbose = FALSE,
  algorithm = "Weiszfeld",
  ...
)
}
\arguments{
\item{o}{An object of loca.p class.}

\item{x}{The x coordinate of the starting point. It's default value is 0.}

\item{y}{The y coordinate of the starting point. It's default value is 0.}

\item{lp}{If given, the \eqn{l_p} norm will be used instead of the Euclidean norm.}

\item{max.iter}{Maximum number of iterations allowed. It's default value is 100000.}

\item{eps}{The module of the gradient in the stop rule. It's default value is 1e-3.}

\item{verbose}{If TRUE the function produces detailed output. It's default value is FALSE.}

\item{algorithm}{The method to be use. For this version of the package, the valid values are: "gradient" for a gradient based method, "search" for local search method (this option is deprecated), "ucminf" for optimization with ucminf from ucminf package, and "Weiszfeld" for the Weiszfeld method or any of the valid method for optim function, now "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN". "Weiszfeld" is the default value.}

\item{\ldots}{Other options for optimization algorithms.}
}
\value{
\code{distsummin} returns an array with the coordinates of the solution point.
}
\description{
Solve the min-sum location problem for a given \code{loca.p} class object.
}
\details{
The algorithms Weiszfeld and gradient include and optimality test for demand points.
The Weiszfeld version of the algorithm also implements slow convergence test and accelerator procedure.

If \eqn{p < 1} thus \eqn{l_p} is not a norm, so, only \eqn{p \ge 1} are valid values.

Since \eqn{l_2} norm is the Euclidean norm, when \eqn{p=2} \code{distsumlpmin} are equal to \code{distsummin}.
But the computations involved are greater for the first form.

max.iter for SANN algorithm is the number of evaluation of objective function, so this method usually requires large values of max.iter to reach optimal value

The function zsummin is deprecated and will be removed from new versions of the package.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))
# Compute the minimum
sol<-distsummin(loca)

# Show the result
sol

# Evaluation of the objective function at solution point
distsum(loca, sol[1], sol[2])

}
\seealso{
See also \code{\link{orloca-package}}, \code{\link{loca.p}} and \code{\link{distsum}}.
}
\keyword{classes}
\keyword{optimize}
