% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suv.R
\name{leanBodyMass}
\alias{leanBodyMass}
\alias{Summarizing SUVs}
\alias{hotSpotSUV}
\alias{totalSUV}
\title{Calculating the Lean Body Mass}
\usage{
leanBodyMass(height, weight, gender)

hotSpotSUV(suv, radius = 10, type = "3D")

totalSUV(suv, mask, z, bg, local = TRUE)
}
\arguments{
\item{height}{is a vector of heights in centimeters.}

\item{weight}{is a vector of weights in kilograms.}

\item{gender}{is a character vector (may be of length one) with the value
\dQuote{male} or \dQuote{female}.}

\item{suv}{is the standard uptake value (SUV).}

\item{radius}{is the desired hotspot radius (units = voxels).}

\item{type}{is a character string (acceptable values are \code{2D} or
\code{3D}) that determines the dimension of the hot spot (default =
\code{3D}).}

\item{mask}{is a multidimensional array of logical values.}

\item{z}{is the slice index.}

\item{bg}{is the estimated background SUV.}

\item{local}{is a logical value.}
}
\value{
Vector of lean body mass values in kilograms.

...
}
\description{
The lean body mass (LBM) is calculated according to the formula
\deqn{1.1\cdot\mbox{weight}-128\cdot(\mbox{weight}/\mbox{height})^2} if male
and \deqn{1.07\cdot\mbox{weight}-148\cdot(\mbox{weight}/\mbox{height})^2} if
female.

The standard uptake value (SUV) is summarized using the hotspot 
method or by calculating total volume of the high values.
}
\examples{
library(oro.pet)
n <- 11
h <- seq(200, 150, length=n)
w <- seq(80, 120, length=n)
cbind(h, w, leanBodyMass(h, w, "male"), leanBodyMass(h, w, "female"))
}
\references{
Sugawara, Y., K. R. Zasadny, A. W. Neuhoff, R. L. Wahl (1999)
Reevaluation of the Standardized Uptake Value for FDG: Variations with Body
Weight and Methods for Correction, \emph{Radiology} \bold{213}: 521--525.
}
\seealso{
\code{\link{standardUptakeValue}}

\code{\link{leanBodyMass}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
