% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.r
\name{print.orthoDr}
\alias{print.orthoDr}
\title{Print a \code{orthoDr} object}
\usage{
\method{print}{orthoDr}(x, ...)
}
\arguments{
\item{x}{A fitted \code{orthoDr} object}

\item{...}{Additional parameters, not used.}
}
\value{
Sliently returns the \code{orthoDr} object supplied into the function to
allow for use with pipes.
}
\description{
Provides a custom print wrapper for displaying \code{orthoDr} fitted models.
}
\examples{
# generate some survival data
N <- 100
P <- 4
dataX <- matrix(rnorm(N * P), N, P)
Y <- exp(-1 + dataX[, 1] + rnorm(N))
Censor <- rbinom(N, 1, 0.8)

# fit the model
orthoDr_surv(dataX, Y, Censor, ndr = 1, method = "dm")
}
