% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_find_profile.R
\name{osrm_find_profile}
\alias{osrm_find_profile}
\title{Locate an OSRM Lua profile (e.g. car.lua) in a host installation}
\usage{
osrm_find_profile(profile = "car.lua")
}
\arguments{
\item{profile}{A single string, the name of the Lua profile file
(e.g. \code{"car.lua"}). Defaults to \code{"car.lua"}.}
}
\value{
The normalized filesystem path to the profile.
}
\description{
By default OSRM ships profiles for "car", "bike" and "foot" in a
\verb{profiles/} directory alongside the binaries.  This function will try to locate \code{osrm-routed} on the \code{PATH}, resolve symlinks, and look first for a \verb{profiles/} directory next to the binary (as placed there by \code{osrm_install()}). If that fails, it looks for sibling directories \code{share/osrm/profiles} and \code{share/osrm-backend/profiles}. IF that fails, it will try to fall back on \code{/usr/local/share/osrm/profiles},\code{/usr/local/share/osrm-backend/profiles}, \code{/usr/share/osrm/profiles}, and \code{/usr/share/osrm-backend/profiles}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )
  osrm_find_profile("car.lua")
  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
}
}

}
