% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pharmacogenomicsGeneQuery.R
\name{pharmacogenomicsGeneQuery}
\alias{pharmacogenomicsGeneQuery}
\title{Retrieve Pharmacogenomics data for a specified gene.}
\usage{
pharmacogenomicsGeneQuery(ensgId)
}
\arguments{
\item{ensgId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000141510).}
}
\value{
Returns a tibble containing pharmacogenomics data for the specified gene.
}
\description{
This function queries the Open Targets GraphQL API to retrieve pharmacogenomics data
for a specified gene.
}
\examples{
\dontrun{
result <- pharmacogenomicsGeneQuery(ensgId = "ENSG00000141510")
}
}
