% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_dispersion_1.R
\encoding{UTF-8}
\name{ordinal_dispersion_1}
\alias{ordinal_dispersion_1}
\title{Computes the standard estimated dispersion of an ordinal time series}
\usage{
ordinal_dispersion_1(series, states, distance = "Block", normalize = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{normalize}{Logical. If \code{normalize = FALSE} (default), the value of the standard estimated dispersion is returned. Otherwise, the function
returns the normalized standard estimated dispersion.}
}
\value{
The standard estimated dispersion.
}
\description{
\code{ordinal_dispersion_1} computes the standard estimated dispersion
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the standard
estimated dispersion given by \eqn{\widehat{disp}_{loc, d}=\frac{1}{T}\sum_{t=1}^Td\big(\overline{X}_t, \widehat{x}_{loc, d}\big)},
where \eqn{\widehat{x}_{loc, d}} is the standard estimate of the location and \eqn{d(\cdot, \cdot)} is a distance between ordinal states.
If \code{normalize = TRUE}, then the normalized dispersion is computed, namely
\eqn{\widehat{disp}_{loc, d}/}max\eqn{_{s_i, s_j \in \mathcal{S}}d(s_i, s_j)}.
}
\examples{
estimated_dispersion <- ordinal_dispersion_1(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the standard dispersion estimate
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
