% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{record_batch_reader}
\alias{record_batch_reader}
\title{record_batch_reader}
\usage{
record_batch_reader(schema_type, bbox = NULL, release_date = "2025-01-22")
}
\arguments{
\item{schema_type}{Character. Required. The type of feature to select. Examples include 'building', 'place', etc.
To learn more, run \code{get_all_overture_schema_types()}.}

\item{bbox}{Numeric vector. Optional. A bounding box specified as c(xmin, ymin, xmax, ymax).
It is recommended to use a bounding box to limit the dataset size and processing time.
Without a bounding box, processing the entire dataset (e.g., buildings over 2 billion) can be time-consuming.}

\item{release_date}{Character. Optional. The dataset release date (format: 'YYYY-MM-DD').
Defaults to the latest available release.}
}
\value{
An \code{sf} object containing the filtered dataset based on the bounding box.
}
\description{
This function retrieves a filtered dataset from the specified Overture dataset type,
optionally within a bounding box, and converts it to an \code{sf} object.
}
\examples{
\donttest{
# Example usage with a bounding box takes > 20 secs
sf_bbox <- c(-122.5, 37.7, -122.3, 37.8)
result <- record_batch_reader(schema_type = 'place', bbox = sf_bbox)
print(result)
}

}
