% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageDiff-package.R
\docType{package}
\name{packageDiff-package}
\alias{packageDiff}
\alias{packageDiff-package}
\title{Package Diff}
\description{
It provides utility functions for investigating changes within R packages.
The \code{pkgInfo} function extracts package information such as exported
and non-exported functions as well as their arguments. The \code{pkgDiff}
function compares this information for two versions of a package and creates
a diff file viewable in a browser.
}
\details{
This package is experimental. Please submit bugs to
\url{https://github.com/couthcommander/packageDiff}.
}
\examples{
tar1 <- system.file("examples", "yaml_2.1.18.tar.gz", package = "packageDiff")
tar2 <- system.file("examples", "yaml_2.1.19.tar.gz", package = "packageDiff")
a <- pkgInfo(tar1)
b <- pkgInfo(tar2)
pkgDiff(a, b)
\donttest{
a <- pkgInfo('https://cran.r-project.org/src/contrib/Archive/yaml/yaml_2.1.18.tar.gz')
b <- pkgInfo('https://cran.r-project.org/src/contrib/Archive/yaml/yaml_2.1.19.tar.gz')
pkgDiff(a, b)
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/couthcommander/packageDiff}
}

}
\author{
Cole Beck \email{cole.beck@vumc.org}

Maintainer: Cole Beck \email{cole.beck@vumc.org}
}
