% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paco_links.r
\name{paco_links}
\alias{paco_links}
\title{Contribution of individual links}
\usage{
paco_links(D, .parallel = FALSE, proc.warnings = TRUE)
}
\arguments{
\item{D}{A list of class \code{paco} as returned by \code{paco::PACo}.}

\item{.parallel}{If TRUE, calculate the jackknife contribution in parallel using the backend provided by foreach.}

\item{proc.warnings}{As in PACo. If \code{TRUE}, any warnings produced by internal calls of \code{paco::PACo} will be available for the user to view. If \code{FALSE}, warnings are internally suppressed.}
}
\value{
The input list of class \code{paco} with the added object jackknife which contains the bias-corrected residual for each link.
}
\description{
Uses a jackknife procedure to perform bias correction on procrustes residuals (i.e. interactions) that are indicative of the degree to which individual interactions are more supportive of a hypothesis of phylogenetic congruence than others. Interactions are iteratively removed, the global fit of the two phylogenies is reassessed and bias in observed residuals calculated and corrected.
}
\examples{
data(gopherlice)
require(ape)
gdist <- cophenetic(gophertree)
ldist <- cophenetic(licetree)
D <- prepare_paco_data(gdist, ldist, gl_links)
D <- add_pcoord(D)
D <- PACo(D, nperm=10, seed=42, method="r0")
D <- paco_links(D)
}
