% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm.R
\name{Kfiltertv}
\alias{Kfiltertv}
\title{Time-varying Kalman filter calculations}
\usage{
Kfiltertv(num, y, Atv, mu0, Sigma0, Phitv, Ups, Gam, Qtv, Rtv, input)
}
\arguments{
\item{num}{the number of samples in the time-series}

\item{y}{values of the time-series}

\item{Atv}{q x p x n observation array}

\item{mu0}{p x 1 vector setting the mean of the system at time zero}

\item{Sigma0}{p x p variance matrix of the system at time zero}

\item{Phitv}{p x p x n array reflecting autoregression of the state variables}

\item{Ups}{p x r matrix with the coefficients/parameters relating the inputs to the system equation}

\item{Gam}{q x r matrix with the coefficients/parameters relating the inputs to the observation equation}

\item{Qtv}{p x p x n array of system stochastic  variance; user needs to ensure positive definite}

\item{Rtv}{q x q x n array observation stochastic variance; user needs to ensure positive definite}

\item{input}{n x r array of the exogenous variables/covariates}
}
\value{
A list of the following elements:
\itemize{
\item \code{xp}   one-step-ahead prediction of the state
\item \code{Pp}   mean square prediction error
\item \code{xf}   filter value of the state
\item \code{Pf}   mean square filter error
\item\code{like}   log-likelihood
\item\code{innov}   innovation series
\item\code{sig}   innovation covariances
\item\code{Kn}   last value of the gain, needed for smoothing
}
}
\description{
Time-varying Kalman filter calculations
}
\details{
For the dimensions of the argument arrays, \code{n} is the length of the
time-series, \code{q} is the dimension of the observation variable(s),
\code{p} is the dimension of the state variable(s), and \code{r} isthe
dimension of the input variable(s). \cr\cr This function is based on the
\code{Kfilter} function of the \emph{astsa} package, modified modified to
allow for time-varying terms for the Kalman filter.  This modification
facilitates fitting a broader array of models and handling non-uniform
temporal spacing of samples.  See the documentation for that function, and
the reference below for additional information.
}
\note{
This function is used in the internal SSM log-likelihood functions for the models.  The user will not need to use this
they create their own model-fitting functions.
}
\examples{
y <- sim.GRW(ms = 0, vs = 1, vp = 0)
n <- length(y)
kf <- Kfiltertv(n ,y = y$mm, Atv = array(1, dim = c(1,1,n)), mu0 = y$mm[1],
                Sigma0 = y$vv[1]/y$nn[1], Phitv = array(1, dim = c(1,1,n)),
                Ups = NULL, Gam = NULL, Qtv = array(1, dim = c(1,1,n)),
                Rtv = array(0, dim = c(1,1,n)), input = NULL)

}
\references{
Shumway, R. H., and D. S. Stoffer. 2017. Time Series Analysis and its Applications (4th Ed.) Springer International.
}
\author{
John Fricks (jfricks@asu.edu)
}
