% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-template.R
\name{pandoc_export_data_file}
\alias{pandoc_export_data_file}
\alias{pandoc_export_reference_doc}
\title{Export Pandoc internal data file}
\usage{
pandoc_export_data_file(file, output = file, version = "default")

pandoc_export_reference_doc(type = c("docx", "pptx"), version = "default")
}
\arguments{
\item{file}{One of data file name included in Pandoc (e.g \code{reference.pptx}, \code{styles.html})}

\item{output}{Path where to export the file. Default to working directory
with the same file name.}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}

\item{type}{one of \code{docx} or \code{pptx} depending on the reference doc to export.}
}
\value{
the \code{output} (invisibly) where export has been done
}
\description{
This correspond to the \href{https://pandoc.org/MANUAL.html#option--print-default-data-file}{\code{--print-default-data-file} CLI flag} using
also \code{--output} to write a export a data file built in Pandoc.
}
\details{
\code{pandoc_export_reference_doc()} is a helper to quickly get the reference doc for
Word document (\code{reference.docx}) or Powerpoint document (\code{reference.pptx})
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
withr::local_dir(withr::local_tempdir())
}
# export style.html file included in Pandoc HTML template
pandoc_export_data_file("styles.html", output = "custom.html")
# export css file used for epub by default
pandoc_export_data_file("epub.css")
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_available() && rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
withr::local_dir(withr::local_tempdir())
}
pandoc_export_reference_doc("docx")
pandoc_export_reference_doc("pptx")
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.11.4") && rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
withr::local_dir(withr::local_tempdir())
}
pandoc_export_reference_doc("pptx", version = "2.11.4")
\dontshow{\}) # examplesIf}
}
