% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_finder.R
\name{corr_finder}
\alias{corr_finder}
\title{Wrapper for find correlations}
\usage{
corr_finder(df, corr_cutoff)
}
\arguments{
\item{df}{The dataframe to use.}

\item{corr_cutoff}{The correlation cutoff to pass to findCorrelations}
}
\description{
Just a helper function for correl_panel.
}
\examples{

X_1 <- rnorm(1000)
X_2 <- rnorm(1000) + 0.6 * X_1
X_3 <- rnorm(1000) - 0.4 * X_1

data_fm <- do.call( cbind, list( X_1,
                                 X_2,
                                 X_3 ))

corr_finder( df = data_fm,
             corr_cutoff = 0.3 )


}
