% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lead_panel.R
\name{panel_lead}
\alias{panel_lead}
\title{Tidy panel leading}
\usage{
panel_lead(data, cross.section, time.variable = NULL, leads = 1,
  variables.selected = NULL, keep.original = TRUE)
}
\arguments{
\item{data}{The data input, anything coercible to a data.table.}

\item{cross.section}{The cross section argument, see examples.}

\item{time.variable}{The variable to indicate time in your panel. Defaults to NULL, though it is recommended to have a time variable.}

\item{leads}{The leads to use in panel leading.}

\item{variables.selected}{A variable selection for variables to lead, defaults to NULL and leads ALL variables.}

\item{keep.original}{Whether to keep the original unleadged data, defaults to TRUE.}
}
\value{
The leading data.table which contains either only the leading variables, or also the original variables.
}
\description{
Efficient, tidy panel leading
}
\details{
Works on a full data.table backend for maximum speed wherever possible.
}
\examples{


X <- matrix(rnorm(4000),800,5)
tim <- seq(1:400)
geo_AT <- rep(c("AT"), length = 400)
geo_NO <- rep(c("NO"), length = 400)
both_vec_1 <- cbind(tim,geo_NO)
both_vec_2 <- cbind(tim,geo_AT)
both <- rbind(both_vec_1,both_vec_2)
names(both[,"geo_NO"]) <- "geo"
X <- cbind(both,X)

panel_lead(data = X,
          cross.section = "geo_NO",
          time.variable = "tim",
          leads = 5,
          variables.selected = c("V5","tim", "V7"),
          keep.original = TRUE)



}
