% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{baxter_data}
\alias{baxter_data}
\alias{baxter_clinical}
\alias{baxter_otu}
\alias{baxter_family}
\alias{baxter_genus}
\alias{baxter_data_dictionary}
\title{Microbiome data}
\format{
5 data frames

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 172 rows and 1234 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 172 rows and 35 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 172 rows and 82 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1351 rows and 3 columns.
}
\source{
Baxter et al. (2016) \doi{10.1186/s13073-016-0290-3}
}
\usage{
baxter_clinical

baxter_otu

baxter_family

baxter_genus

baxter_data_dictionary
}
\description{
Clinical and microbiome data derived from "Microbiota-based model improves
the sensitivity of fecal immunochemical test for detecting colonic lesions"
by Baxter et al. (2016). These data represent a subset of 172 health
participants. \code{baxter_clinical} contains 8 clinical variables for each of the
participants: \code{sample_name}, \code{id}, \code{age}, \code{bmi}, \code{gender}, \code{height},
\code{total_reads}, and \code{disease_state} (all \code{H} for healthy). \code{baxter_otu} has
1,234 columns, where each columns represent an Operational Taxonomic Unit
(OTU). OTUs are species-like relationships among bacteria determined by
analyzing their RNA. The cells are logged counts for how often the OTU was
detected in a participant's stool sample. Each column name is a shorthand
name, e.g. \code{otu1}; you can find the true name of the OTU mapped in
\code{baxter_data_dictionary}. \code{baxter_family} and \code{baxter_genus} are also logged
counts but instead group OTUs at the family and genus level, respectively, a
common approach to reducing microbiome data. Likewise, the column names are
shorthands, which you can find mapped in \code{baxter_data_dictionary}.
}
\keyword{datasets}
