% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_functions.R
\name{read_motive_csv}
\alias{read_motive_csv}
\title{Import data from a CSV exported from Optitrack's Motive software}
\usage{
read_motive_csv(file_name, file_id = NA, simplify_marker_naming = TRUE, ...)
}
\arguments{
\item{file_name}{A file (or path to file) in CSV format}

\item{file_id}{(Optional) identifier for this file. If not supplied, this
defaults to \code{basename(file_name)}.}

\item{simplify_marker_naming}{If Markers are encountered, should they be
renamed from "Subject:marker" to "marker"? Defaults to TRUE}

\item{...}{Additional arguments passed from other \code{pathviewr} functions}
}
\value{
A tibble with numerical data in columns. The first two columns will
have frame numbers and time (assumed to be in secs), respectively. Columns 3
and beyond will contain the numerical data on the position or rotation of
rigid bodies and/or markers that appear in the Motive CSV file. Each row
corresponds to the position or rotation of all objects at a given time
(frame).
}
\description{
\code{read_motive_csv()} is designed to import data from a CSV that has been
exported from Optitrack's Motive software. The resultant object is a tibble
that additionally has important metadata stored as attributes (see Details).
}
\details{
Uses \code{data.table::fread()} to import data from a CSV file and
ultimately store it in a tibble. This object is also labeled with the
attribute \code{pathviewr_steps} with value \code{viewr} to indicate that it
has been imported by \code{pathviewr} and should be friendly towards use with
other functions in our package. Additionally, the following metadata are
stored in the tibble's attributes: header information from the Motive CSV
file (\code{header}), original IDs for each object (\code{Motive_IDs}), the
name of each subject in each data column (\code{subject_names_full}) and
unique values of subject names (\code{subject_names_simple}), the type of
data (rigid body or marker) that appears in each column
(\code{data_types_full}) and overall (\code{data_types_simple}), and original
data column names in the CSV (\code{d1, d2}). See Example below for example
code to inspect attributes.
}
\section{Warning}{

This function was written to read CSVs exported using Motive's Format Version
1.23 and is not guaranteed to work with those from other versions. Please
file an Issue on our Github page if you encounter any problems.
}

\examples{
library(pathviewr)

## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Names of variables in the resulting tibble
names(motive_data)

## A variety of metadata are stored as attributes. Of particular interest:
attr(motive_data, "pathviewr_steps")
attr(motive_data, "file_id")
attr(motive_data, "header")
attr(motive_data, "Motive_IDs")
attr(motive_data, "subject_names_full")
attr(motive_data, "subject_names_simple")
attr(motive_data, "motive_data_names")
attr(motive_data, "motive_data_types_full")
attr(motive_data, "motive_data_types_simple")

## Of course, all attributes can be viewed as a (long) list via:
attributes(motive_data)

}
\seealso{
\code{\link{read_flydra_mat}} for importing Flydra data

Other data import functions: 
\code{\link{as_viewr}()},
\code{\link{import_and_clean_batch}()},
\code{\link{import_batch}()},
\code{\link{read_flydra_mat}()}
}
\author{
Vikram B. Baliga
}
\concept{data import functions}
