% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{separate_trajectories}
\alias{separate_trajectories}
\title{Separate rows of data into separately labeled trajectories.}
\usage{
separate_trajectories(
  obj_name,
  max_frame_gap = 1,
  frame_rate_proportion = 0.1,
  frame_gap_messaging = FALSE,
  frame_gap_plotting = FALSE,
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{max_frame_gap}{Default 1; defines the largest permissible gap in data
before a new trajectory is forced to be defined. Can be either a numeric
value or "autodetect". See Details for more.}

\item{frame_rate_proportion}{Default 0.10; if \code{max_frame_gap =
  "autodetect"}, proportion of frame rate to be used as a reference (see
Details).}

\item{frame_gap_messaging}{Default FALSE; should frame gaps be reported in
the console?}

\item{frame_gap_plotting}{Default FALSE; should frame gap diagnostic plots be
shown?}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which a new column
\code{file_sub_traj} is added, which labels trajectories within the data by
concatenating file name, subject name, and a trajectory number (all
separated by underscores).
}
\description{
Separate rows of data into separately labeled trajectories.
}
\details{
This function is designed to separate rows of data into separately
labeled trajectories.

The \code{max_frame_gap} parameter determines how trajectories will be
separated. If numeric, the function uses the supplied value as the largest
permissible gap in frames before a new trajectory is defined.

If \code{max_frame_gap = "autodetect"} is used, the function
attempts to guesstimate the best value(s) of \code{max_frame_gap}. This is
performed separately for each subject in the data set, i.e. as many
\code{max_frame_gap} values will be estimated as there are unique subjects.
The highest possible value of any \code{max_frame_gap} is first set as a
proportion of the capture frame rate, as defined by the
\code{frame_rate_proportion} parameter (default 0.10). For each subject, a
plot of total trajectory counts vs. max frame gap values is created
internally (but can be plotted via setting
\code{frame_gap_plotting = TRUE}). As larger max frame gaps are allowed,
trajectory count will necessarily decrease but may reach a value that
likely represents the "best" option. The "elbow" of that plot is then used
to find an estimate of the best max frame gap value to use.
}
\examples{
## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "select" step before running select_x_percent().
motive_selected <-
  motive_data \%>\%
  relabel_viewr_axes() \%>\%
  gather_tunnel_data() \%>\%
  trim_tunnel_outliers() \%>\%
  rotate_tunnel() \%>\%
  select_x_percent(desired_percent = 50)

## Now separate trajectories using autodetect
motive_separated <-
  motive_selected \%>\%
  separate_trajectories(max_frame_gap = "autodetect",
                        frame_rate_proportion = 0.1)

## See new column file_sub_traj for trajectory labeling
names(motive_separated)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other functions that define or clean trajectories: 
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga and Melissa S. Armstrong
}
\concept{data cleaning functions}
\concept{functions that define or clean trajectories}
