% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segplot.R
\name{segplot}
\alias{segplot}
\title{Plot the segment-analysis model}
\usage{
segplot(
  segdata,
  labels = TRUE,
  lab.cex = 0.9,
  out.lwd = 1,
  out.lty = 1,
  out.lcol = "black",
  tick.loc = c(-1, -0.5, 0.5, 1),
  square = TRUE,
  ...
)
}
\arguments{
\item{segdata}{(required) a data frame, possibly a result from the
\code{\link[=colspace]{colspace()}} or \code{\link[=segspace]{segspace()}} function, containing values for 'LM' and 'MS'
as columns (labeled as such).}

\item{labels}{logical. Should the name of each cone be printed next to the
corresponding vertex?}

\item{tick.loc}{a numeric vector specifying the location of tick marks on x &
y axes.}

\item{square}{logical. Should the aspect ratio of the plot be held to 1:1?
(defaults to \code{TRUE}).}

\item{...}{additional graphical options. See \code{\link[=par]{par()}}.}
}
\description{
Produces a plot based on Endler's (1990) segment analysis.
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers, visual = "segment", achromatic = "all")
seg.flowers <- colspace(vis.flowers, space = "segment")
plot(seg.flowers)
}
\references{
Endler, J. A. (1990) On the measurement and classification of
colour in studies of animal colour patterns. Biological Journal of the
Linnean Society, 41, 315-352.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
