% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_update_rule}
\alias{datazone_update_rule}
\title{Updates a rule}
\usage{
datazone_update_rule(
  description = NULL,
  detail = NULL,
  domainIdentifier,
  identifier,
  includeChildDomainUnits = NULL,
  name = NULL,
  scope = NULL
)
}
\arguments{
\item{description}{The description of the rule.}

\item{detail}{The detail of the rule.}

\item{domainIdentifier}{[required] The ID of the domain in which a rule is to be updated.}

\item{identifier}{[required] The ID of the rule that is to be updated}

\item{includeChildDomainUnits}{Specifies whether to update this rule in the child domain units.}

\item{name}{The name of the rule.}

\item{scope}{The scrope of the rule.}
}
\description{
Updates a rule. In Amazon DataZone, a rule is a formal agreement that enforces specific requirements across user workflows (e.g., publishing assets to the catalog, requesting subscriptions, creating projects) within the Amazon DataZone data portal. These rules help maintain consistency, ensure compliance, and uphold governance standards in data management processes. For instance, a metadata enforcement rule can specify the required information for creating a subscription request or publishing a data asset to the catalog, ensuring alignment with organizational standards.

See \url{https://www.paws-r-sdk.com/docs/datazone_update_rule/} for full documentation.
}
\keyword{internal}
