% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_data_set}
\alias{quicksight_update_data_set}
\title{Updates a dataset}
\usage{
quicksight_update_data_set(
  AwsAccountId,
  DataSetId,
  Name,
  PhysicalTableMap,
  LogicalTableMap = NULL,
  ImportMode,
  ColumnGroups = NULL,
  FieldFolders = NULL,
  RowLevelPermissionDataSet = NULL,
  RowLevelPermissionTagConfiguration = NULL,
  ColumnLevelPermissionRules = NULL,
  DataSetUsageConfiguration = NULL,
  DatasetParameters = NULL,
  PerformanceConfiguration = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID.}

\item{DataSetId}{[required] The ID for the dataset that you want to update. This ID is unique per
Amazon Web Services Region for each Amazon Web Services account.}

\item{Name}{[required] The display name for the dataset.}

\item{PhysicalTableMap}{[required] Declares the physical tables that are available in the underlying data
sources.}

\item{LogicalTableMap}{Configures the combination and transformation of the data from the
physical tables.}

\item{ImportMode}{[required] Indicates whether you want to import the data into SPICE.}

\item{ColumnGroups}{Groupings of columns that work together in certain Amazon QuickSight
features. Currently, only geospatial hierarchy is supported.}

\item{FieldFolders}{The folder that contains fields and nested subfolders for your dataset.}

\item{RowLevelPermissionDataSet}{The row-level security configuration for the data you want to create.}

\item{RowLevelPermissionTagConfiguration}{The configuration of tags on a dataset to set row-level security.
Row-level security tags are currently supported for anonymous embedding
only.}

\item{ColumnLevelPermissionRules}{A set of one or more definitions of a \code{ColumnLevelPermissionRule}.}

\item{DataSetUsageConfiguration}{}

\item{DatasetParameters}{The parameter declarations of the dataset.}

\item{PerformanceConfiguration}{The configuration for the performance optimization of the dataset that
contains a \code{UniqueKey} configuration.}
}
\description{
Updates a dataset. This operation doesn't support datasets that include uploaded files as a source. Partial updates are not supported by this operation.

See \url{https://www.paws-r-sdk.com/docs/quicksight_update_data_set/} for full documentation.
}
\keyword{internal}
