% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_create_lf_tag_expression}
\alias{lakeformation_create_lf_tag_expression}
\title{Creates a new LF-Tag expression with the provided name, description,
catalog ID, and expression body}
\usage{
lakeformation_create_lf_tag_expression(
  Name,
  Description = NULL,
  CatalogId = NULL,
  Expression
)
}
\arguments{
\item{Name}{[required] A name for the expression.}

\item{Description}{A description with information about the LF-Tag expression.}

\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{Expression}{[required] A list of LF-Tag conditions (key-value pairs).}
}
\description{
Creates a new LF-Tag expression with the provided name, description, catalog ID, and expression body. This call fails if a LF-Tag expression with the same name already exists in the caller’s account or if the underlying LF-Tags don't exist. To call this API operation, caller needs the following Lake Formation permissions:

See \url{https://www.paws-r-sdk.com/docs/lakeformation_create_lf_tag_expression/} for full documentation.
}
\keyword{internal}
