% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeconnections_service.R
\name{codeconnections}
\alias{codeconnections}
\title{AWS CodeConnections}
\usage{
codeconnections(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This Amazon Web Services CodeConnections API Reference provides
descriptions and usage examples of the operations and data types for the
Amazon Web Services CodeConnections API. You can use the connections API
to work with connections and installations.

\emph{Connections} are configurations that you use to connect Amazon Web
Services resources to external code repositories. Each connection is a
resource that can be given to services such as CodePipeline to connect
to a third-party repository such as Bitbucket. For example, you can add
the connection in CodePipeline so that it triggers your pipeline when a
code change is made to your third-party code repository. Each connection
is named and associated with a unique ARN that is used to reference the
connection.

When you create a connection, the console initiates a third-party
connection handshake. \emph{Installations} are the apps that are used to
conduct this handshake. For example, the installation for the Bitbucket
provider type is the Bitbucket app. When you create a connection, you
can choose an existing installation or create one.

When you want to create a connection to an installed provider type such
as GitHub Enterprise Server, you create a \emph{host} for your connections.

You can work with connections by calling:
\itemize{
\item \code{\link[=codeconnections_create_connection]{create_connection}}, which
creates a uniquely named connection that can be referenced by
services such as CodePipeline.
\item \code{\link[=codeconnections_delete_connection]{delete_connection}}, which
deletes the specified connection.
\item \code{\link[=codeconnections_get_connection]{get_connection}}, which returns
information about the connection, including the connection status.
\item \code{\link[=codeconnections_list_connections]{list_connections}}, which lists
the connections associated with your account.
}

You can work with hosts by calling:
\itemize{
\item \code{\link[=codeconnections_create_host]{create_host}}, which creates a host
that represents the infrastructure where your provider is installed.
\item \code{\link[=codeconnections_delete_host]{delete_host}}, which deletes the
specified host.
\item \code{\link[=codeconnections_get_host]{get_host}}, which returns information
about the host, including the setup status.
\item \code{\link[=codeconnections_list_hosts]{list_hosts}}, which lists the hosts
associated with your account.
}

You can work with tags in Amazon Web Services CodeConnections by calling
the following:
\itemize{
\item \code{\link[=codeconnections_list_tags_for_resource]{list_tags_for_resource}},
which gets information about Amazon Web Services tags for a
specified Amazon Resource Name (ARN) in Amazon Web Services
CodeConnections.
\item \code{\link[=codeconnections_tag_resource]{tag_resource}}, which adds or
updates tags for a resource in Amazon Web Services CodeConnections.
\item \code{\link[=codeconnections_untag_resource]{untag_resource}}, which removes
tags for a resource in Amazon Web Services CodeConnections.
}

For information about how to use Amazon Web Services CodeConnections,
see the \href{https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html}{Developer Tools User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codeconnections(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codeconnections_create_connection]{create_connection} \tab Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories\cr
\link[=codeconnections_create_host]{create_host} \tab Creates a resource that represents the infrastructure where a third-party provider is installed\cr
\link[=codeconnections_create_repository_link]{create_repository_link} \tab Creates a link to a specified external Git repository\cr
\link[=codeconnections_create_sync_configuration]{create_sync_configuration} \tab Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource\cr
\link[=codeconnections_delete_connection]{delete_connection} \tab The connection to be deleted\cr
\link[=codeconnections_delete_host]{delete_host} \tab The host to be deleted\cr
\link[=codeconnections_delete_repository_link]{delete_repository_link} \tab Deletes the association between your connection and a specified external Git repository\cr
\link[=codeconnections_delete_sync_configuration]{delete_sync_configuration} \tab Deletes the sync configuration for a specified repository and connection\cr
\link[=codeconnections_get_connection]{get_connection} \tab Returns the connection ARN and details such as status, owner, and provider type\cr
\link[=codeconnections_get_host]{get_host} \tab Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration\cr
\link[=codeconnections_get_repository_link]{get_repository_link} \tab Returns details about a repository link\cr
\link[=codeconnections_get_repository_sync_status]{get_repository_sync_status} \tab Returns details about the sync status for a repository\cr
\link[=codeconnections_get_resource_sync_status]{get_resource_sync_status} \tab Returns the status of the sync with the Git repository for a specific Amazon Web Services resource\cr
\link[=codeconnections_get_sync_blocker_summary]{get_sync_blocker_summary} \tab Returns a list of the most recent sync blockers\cr
\link[=codeconnections_get_sync_configuration]{get_sync_configuration} \tab Returns details about a sync configuration, including the sync type and resource name\cr
\link[=codeconnections_list_connections]{list_connections} \tab Lists the connections associated with your account\cr
\link[=codeconnections_list_hosts]{list_hosts} \tab Lists the hosts associated with your account\cr
\link[=codeconnections_list_repository_links]{list_repository_links} \tab Lists the repository links created for connections in your account\cr
\link[=codeconnections_list_repository_sync_definitions]{list_repository_sync_definitions} \tab Lists the repository sync definitions for repository links in your account\cr
\link[=codeconnections_list_sync_configurations]{list_sync_configurations} \tab Returns a list of sync configurations for a specified repository\cr
\link[=codeconnections_list_tags_for_resource]{list_tags_for_resource} \tab Gets the set of key-value pairs (metadata) that are used to manage the resource\cr
\link[=codeconnections_tag_resource]{tag_resource} \tab Adds to or modifies the tags of the given resource\cr
\link[=codeconnections_untag_resource]{untag_resource} \tab Removes tags from an Amazon Web Services resource\cr
\link[=codeconnections_update_host]{update_host} \tab Updates a specified host with the provided configurations\cr
\link[=codeconnections_update_repository_link]{update_repository_link} \tab Updates the association between your connection and a specified external Git repository\cr
\link[=codeconnections_update_sync_blocker]{update_sync_blocker} \tab Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue\cr
\link[=codeconnections_update_sync_configuration]{update_sync_configuration} \tab Updates the sync configuration for your connection and a specified external Git repository
}
}

\examples{
\dontrun{
svc <- codeconnections()
svc$create_connection(
  Foo = 123
)
}

}
