% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_dataset}
\alias{comprehend_create_dataset}
\title{Creates a dataset to upload training or test data for a model associated
with a flywheel}
\usage{
comprehend_create_dataset(
  FlywheelArn,
  DatasetName,
  DatasetType = NULL,
  Description = NULL,
  InputDataConfig,
  ClientRequestToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{FlywheelArn}{[required] The Amazon Resource Number (ARN) of the flywheel of the flywheel to
receive the data.}

\item{DatasetName}{[required] Name of the dataset.}

\item{DatasetType}{The dataset type. You can specify that the data in a dataset is for
training the model or for testing the model.}

\item{Description}{Description of the dataset.}

\item{InputDataConfig}{[required] Information about the input data configuration. The type of input data
varies based on the format of the input and whether the data is for a
classifier model or an entity recognition model.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{Tags}{Tags for the dataset.}
}
\description{
Creates a dataset to upload training or test data for a model associated with a flywheel. For more information about datasets, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html}{Flywheel overview} in the \emph{Amazon Comprehend Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/comprehend_create_dataset/} for full documentation.
}
\keyword{internal}
