% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_get_face_liveness_session_results}
\alias{rekognition_get_face_liveness_session_results}
\title{Retrieves the results of a specific Face Liveness session}
\usage{
rekognition_get_face_liveness_session_results(SessionId)
}
\arguments{
\item{SessionId}{[required] A unique 128-bit UUID. This is used to uniquely identify the session and
also acts as an idempotency token for all operations associated with the
session.}
}
\description{
Retrieves the results of a specific Face Liveness session. It requires the \code{sessionId} as input, which was created using \code{\link[=rekognition_create_face_liveness_session]{create_face_liveness_session}}. Returns the corresponding Face Liveness confidence score, a reference image that includes a face bounding box, and audit images that also contain face bounding boxes. The Face Liveness confidence score ranges from 0 to 100.

See \url{https://www.paws-r-sdk.com/docs/rekognition_get_face_liveness_session_results/} for full documentation.
}
\keyword{internal}
