% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_language_model}
\alias{transcribeservice_create_language_model}
\title{Creates a new custom language model}
\usage{
transcribeservice_create_language_model(
  LanguageCode,
  BaseModelName,
  ModelName,
  InputDataConfig,
  Tags = NULL
)
}
\arguments{
\item{LanguageCode}{[required] The language code that represents the language of your model. Each
custom language model must contain terms in only one language, and the
language you select for your custom language model must match the
language of your training and tuning data.

For a list of supported languages and their associated language codes,
refer to the \href{https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html}{Supported languages}
table. Note that US English (\code{en-US}) is the only language supported
with Amazon Transcribe Medical.

A custom language model can only be used to transcribe files in the same
language as the model. For example, if you create a custom language
model using US English (\code{en-US}), you can only apply this model to files
that contain English audio.}

\item{BaseModelName}{[required] The Amazon Transcribe standard language model, or base model, used to
create your custom language model. Amazon Transcribe offers two options
for base models: Wideband and Narrowband.

If the audio you want to transcribe has a sample rate of 16,000 Hz or
greater, choose \code{WideBand}. To transcribe audio with a sample rate less
than 16,000 Hz, choose \code{NarrowBand}.}

\item{ModelName}{[required] A unique name, chosen by you, for your custom language model.

This name is case sensitive, cannot contain spaces, and must be unique
within an Amazon Web Services account. If you try to create a new custom
language model with the same name as an existing custom language model,
you get a \code{ConflictException} error.}

\item{InputDataConfig}{[required] Contains the Amazon S3 location of the training data you want to use to
create a new custom language model, and permissions to access this
location.

When using \code{InputDataConfig}, you must include these sub-parameters:
\code{S3Uri}, which is the Amazon S3 location of your training data, and
\code{DataAccessRoleArn}, which is the Amazon Resource Name (ARN) of the role
that has permission to access your specified Amazon S3 location. You can
optionally include \code{TuningDataS3Uri}, which is the Amazon S3 location of
your tuning data. If you specify different Amazon S3 locations for
training and tuning data, the ARN you use must have permissions to
access both locations.}

\item{Tags}{Adds one or more custom tags, each in the form of a key:value pair, to a
new custom language model at the time you create this new model.

To learn more about using tags with Amazon Transcribe, refer to \href{https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html}{Tagging resources}.}
}
\description{
Creates a new custom language model.

See \url{https://www.paws-r-sdk.com/docs/transcribeservice_create_language_model/} for full documentation.
}
\keyword{internal}
