% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_associate_node}
\alias{opsworkscm_associate_node}
\title{Associates a new node with the server}
\usage{
opsworkscm_associate_node(ServerName, NodeName, EngineAttributes)
}
\arguments{
\item{ServerName}{[required] The name of the server with which to associate the node.}

\item{NodeName}{[required] The name of the node.}

\item{EngineAttributes}{[required] Engine attributes used for associating the node.

\strong{Attributes accepted in a AssociateNode request for Chef}
\itemize{
\item \code{CHEF_ORGANIZATION}: The Chef organization with which the node is
associated. By default only one organization named \code{default} can
exist.
\item \code{CHEF_NODE_PUBLIC_KEY}: A PEM-formatted public key. This key is
required for the \code{chef-client} agent to access the Chef API.
}

\strong{Attributes accepted in a AssociateNode request for Puppet}
\itemize{
\item \code{PUPPET_NODE_CSR}: A PEM-formatted certificate-signing request (CSR)
that is created by the node.
}}
}
\description{
Associates a new node with the server. For more information about how to disassociate a node, see \code{\link[=opsworkscm_disassociate_node]{disassociate_node}}.

See \url{https://www.paws-r-sdk.com/docs/opsworkscm_associate_node/} for full documentation.
}
\keyword{internal}
