% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_list_analysis_reports}
\alias{networkfirewall_list_analysis_reports}
\title{Returns a list of all traffic analysis reports generated within the last
30 days}
\usage{
networkfirewall_list_analysis_reports(
  FirewallName = NULL,
  FirewallArn = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{FirewallName}{The descriptive name of the firewall. You can't change the name of a
firewall after you create it.

You must specify the ARN or the name, and you can specify both.}

\item{FirewallArn}{The Amazon Resource Name (ARN) of the firewall.

You must specify the ARN or the name, and you can specify both.}

\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Network Firewall returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}

\item{MaxResults}{The maximum number of objects that you want Network Firewall to return
for this request. If more objects are available, in the response,
Network Firewall provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}
}
\description{
Returns a list of all traffic analysis reports generated within the last 30 days.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_list_analysis_reports/} for full documentation.
}
\keyword{internal}
